/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ExtendsEvent;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.util.CommandLabelFactory;

public class ExtendsRecord
extends SimpleRecord {
    private DesignElement element = null;
    protected ElementRefValue newParent = null;
    private DesignElement oldParent = null;
    private String oldName = null;

    public ExtendsRecord(DesignElement obj, ElementRefValue parent) {
        assert (obj != null);
        this.element = obj;
        this.newParent = parent;
        this.oldParent = obj.getExtendsElement();
        if (this.oldParent == null) {
            this.oldName = obj.getExtendsName();
        }
        this.label = CommandLabelFactory.getCommandLabel("Message.SetExtends");
    }

    @Override
    protected void perform(boolean undo) {
        if (undo) {
            if (this.oldName != null) {
                this.element.setExtendsName(this.oldName);
            } else {
                this.element.setExtendsElement(this.oldParent);
            }
        } else {
            DesignElement parent = this.newParent == null ? null : this.newParent.getElement();
            this.element.setExtendsElement(parent);
        }
    }

    @Override
    public DesignElement getTarget() {
        return this.element;
    }

    @Override
    public NotificationEvent getEvent() {
        return new ExtendsEvent(this.element);
    }
}

