/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.elements.table.LayoutCell;
import org.eclipse.birt.report.model.api.elements.table.LayoutGroupBand;
import org.eclipse.birt.report.model.api.elements.table.LayoutRow;
import org.eclipse.birt.report.model.api.elements.table.LayoutSlot;
import org.eclipse.birt.report.model.api.elements.table.LayoutTable;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;

class DropStrategy {
    private LayoutTable layoutTable;

    public DropStrategy(LayoutTable layoutTable) {
        this.layoutTable = layoutTable;
    }

    public void applyStrategy() {
        TableItem table = this.layoutTable.table;
        List<DesignElement> groups = table.getGroups();
        int i = 0;
        while (i < groups.size()) {
            TableGroup group = (TableGroup)groups.get(i);
            int groupLevel = group.getGroupLevel();
            this.resolveDropInSlot(group, groupLevel, this.layoutTable.getGroupHeaders().getLayoutSlotWithGroupLevel(groupLevel));
            ++i;
        }
    }

    private void resolveDropInSlot(TableGroup group, int groupLevel, LayoutSlot layoutGH) {
        ContainerSlot groupHeader = group.getSlot(0);
        if (groupHeader.getCount() < 1) {
            return;
        }
        int rowId = groupHeader.getCount() - 1;
        TableRow row = (TableRow)groupHeader.getContent(rowId);
        this.resolveDropInRow(row, rowId, groupLevel, layoutGH.getLayoutRow(rowId));
    }

    private void resolveDropInRow(TableRow row, int rowId, int groupLevel, LayoutRow layoutRow) {
        List<DesignElement> cells = new ContainerContext((DesignElement)row, 0).getContents(this.layoutTable.getModule());
        int i = 0;
        while (i < cells.size()) {
            Cell cell = (Cell)cells.get(i);
            this.resolveDropForCell(cell, rowId, groupLevel, layoutRow);
            ++i;
        }
    }

    private void resolveDropForCell(Cell cell, int rowId, int groupLevel, LayoutRow layoutRow) {
        String drop = (String)cell.getLocalProperty(null, "drop");
        if (drop == null || "none".equalsIgnoreCase(drop)) {
            return;
        }
        int colId = layoutRow.findCellColumnPos(cell) - 1;
        LayoutCell original = layoutRow.getLayoutCell(colId);
        if (!original.isCellStartPosition()) {
            return;
        }
        int colSpan = cell.getColSpan(this.layoutTable.getModule());
        List layoutSlots = this.getSpanSlots(groupLevel, colId, colSpan, drop);
        this.updateUsedLayoutCell(layoutRow, colId, cell, layoutSlots);
        this.updateSpannedLayoutCell(layoutSlots, cell, colId, original.getCellId());
    }

    private List getSpanSlots(int groupLevel, int colId, int colSpan, String drop) {
        ArrayList<LayoutSlot> layoutSlots = new ArrayList<LayoutSlot>();
        LayoutGroupBand groups = this.layoutTable.getGroupHeaders();
        int i = 0;
        while (i < groups.getGroupCount()) {
            LayoutSlot slot = groups.getLayoutSlot(i);
            if (slot.getGroupLevel() > groupLevel) {
                if (this.isConflictArea(slot, colId, colSpan, true)) {
                    return Collections.EMPTY_LIST;
                }
                layoutSlots.add(slot);
            }
            ++i;
        }
        LayoutSlot detail = this.layoutTable.getDetail();
        if (this.isConflictArea(detail, colId, colSpan, false)) {
            return Collections.EMPTY_LIST;
        }
        layoutSlots.add(detail);
        groups = this.layoutTable.getGroupFooters();
        if ("all".equalsIgnoreCase(drop)) {
            int i2 = 0;
            while (i2 < groups.getGroupCount()) {
                LayoutSlot slot = groups.getLayoutSlot(i2);
                if (slot.getGroupLevel() >= groupLevel) {
                    if (this.isConflictArea(slot, colId, colSpan, false)) {
                        return Collections.EMPTY_LIST;
                    }
                    layoutSlots.add(slot);
                }
                ++i2;
            }
        }
        return layoutSlots;
    }

    private void updateUsedLayoutCell(LayoutRow row, int colId, Cell cell, List spannedSlots) {
        int rowSpanForDrop = 0;
        int i = 0;
        while (i < spannedSlots.size()) {
            rowSpanForDrop += ((LayoutSlot)spannedSlots.get(i)).getRowCount();
            ++i;
        }
        i = 0;
        while (i < cell.getColSpan(this.layoutTable.getModule())) {
            LayoutCell layoutCell = row.getLayoutCell(i + colId);
            assert (layoutCell.isUsed());
            layoutCell.setEffectualDrop(true);
            layoutCell.setRowSpanForDrop(rowSpanForDrop);
            ++i;
        }
    }

    private void updateSpannedLayoutCell(List layoutSlots, Cell cell, int colId, int cellId) {
        int i = 0;
        while (i < layoutSlots.size()) {
            LayoutSlot slot = (LayoutSlot)layoutSlots.get(i);
            slot.addDropSpannedCells(cellId, colId, cell.getColSpan(this.layoutTable.getModule()), i + 1, cell);
            ++i;
        }
    }

    private boolean isConflictArea(LayoutSlot slot, int colId, int colSpan, boolean inGH) {
        List retValue = slot.checkOverlappedLayoutCells(0, colId, slot.getRowCount(), colSpan);
        int i = 0;
        while (i < retValue.size()) {
            LayoutCell cell = (LayoutCell)retValue.get(i);
            if (!cell.isEmptyContent() || inGH && cell.isDropSet()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

