/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Iterator;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedPropertyHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ExtendedProperty;
import org.eclipse.birt.report.model.api.util.StringUtil;

final class ExtendedPropertyHelper {
    ExtendedPropertyHelper() {
    }

    protected static String getExtendedProperty(DesignElementHandle element, String propName, String name) {
        if (StringUtil.isBlank(name)) {
            return null;
        }
        PropertyHandle propertyHandle = element.getPropertyHandle(propName);
        Iterator iter = propertyHandle.iterator();
        while (iter.hasNext()) {
            ExtendedPropertyHandle prop = (ExtendedPropertyHandle)iter.next();
            if (prop.getName() == null || !prop.getName().equalsIgnoreCase(name)) continue;
            return prop.getValue();
        }
        return null;
    }

    protected static void setExtendedProperty(DesignElementHandle element, String propName, String name, String value) throws SemanticException {
        PropertyHandle propertyHandle = element.getPropertyHandle(propName);
        Iterator iter = propertyHandle.iterator();
        while (iter.hasNext()) {
            ExtendedPropertyHandle propHandle = (ExtendedPropertyHandle)iter.next();
            if (propHandle.getName() == null || !propHandle.getName().equalsIgnoreCase(name)) continue;
            propHandle.setValue(value);
            return;
        }
        propertyHandle.addItem(new ExtendedProperty(name, value));
    }
}

