/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.joins.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.editparts.NodeEditPartHelper;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.editpolicies.JoinXYLayoutEditPolicy;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.figures.CubeFigure;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;

public class CubeEditPart
extends NodeEditPartHelper {
    public CubeFigure cubeNode;

    public CubeEditPart(EditPart context, TabularCubeHandle cube) {
        this.setModel(cube);
        this.setParent(context);
    }

    @Override
    protected IFigure createFigure() {
        FreeformLayer f = new FreeformLayer();
        f.setLayoutManager((LayoutManager)new FreeformLayout());
        f.setBorder((Border)new MarginBorder(5));
        return f;
    }

    public TabularCubeHandle getCube() {
        return (TabularCubeHandle)this.getModel();
    }

    protected List getModelChildren() {
        ArrayList<Object> childList = new ArrayList<Object>();
        if (this.getCube() != null) {
            childList.add(this.getCube().getDataSet());
            DimensionHandle[] dimensions = this.getCube().getContents("dimensions").toArray(new DimensionHandle[0]);
            int i = 0;
            while (i < dimensions.length) {
                TabularHierarchyHandle hierarchy = (TabularHierarchyHandle)dimensions[i].getDefaultHierarchy();
                if (hierarchy != null && hierarchy.getDataSet() != null && hierarchy.getDataSet() != this.getCube().getDataSet()) {
                    childList.add(hierarchy);
                }
                ++i;
            }
        }
        return childList;
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new JoinXYLayoutEditPolicy(this.getCube()));
    }

    @Override
    public IFigure getChopFigure() {
        return null;
    }
}

