/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.extension.IElementCommand;

public class ChartSimplePropertyCommandImpl
implements IElementCommand {
    private ChartReportItemImpl item;
    private Object oldValue;
    private Object newValue;
    private DesignElementHandle handle;
    private String propertyName;

    public ChartSimplePropertyCommandImpl(DesignElementHandle handle, ChartReportItemImpl impl, String propName, Object newValue, Object oldValue) {
        this.handle = handle;
        this.item = impl;
        this.propertyName = propName;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public void execute() {
        this.item.basicSetProperty(this.propertyName, this.newValue);
    }

    public void undo() {
        this.item.basicSetProperty(this.propertyName, this.oldValue);
    }

    public void redo() {
        this.item.basicSetProperty(this.propertyName, this.newValue);
    }

    public boolean canUndo() {
        return true;
    }

    public boolean canRedo() {
        return true;
    }

    public String getLabel() {
        return Messages.getString("ChartElementCommandImpl.setProperty." + this.propertyName);
    }

    public DesignElementHandle getElementHandle() {
        return this.handle;
    }
}

