/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.reportitem.ChartSharingQueryHelper;
import org.eclipse.birt.chart.reportitem.api.ChartItemUtil;
import org.eclipse.birt.chart.reportitem.api.ChartReportItemHelper;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.engine.extension.ReportItemQueryBase;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.re.CrosstabQueryUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.MultiViewsHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;

public final class ChartReportItemQueryImpl
extends ReportItemQueryBase {
    private Chart cm = null;
    private ExtendedItemHandle eih = null;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");

    public void setModelObject(ExtendedItemHandle eih) {
        IReportItem item;
        block5: {
            try {
                item = eih.getReportItem();
                if (item != null) break block5;
                try {
                    eih.loadExtendedElement();
                }
                catch (ExtendedElementException eeex) {
                    logger.log((Exception)((Object)eeex));
                }
                item = eih.getReportItem();
                if (item == null) {
                    logger.log(4, Messages.getString("ChartReportItemQueryImpl.log.UnableToLocate"));
                    return;
                }
            }
            catch (ExtendedElementException e) {
                logger.log(4, Messages.getString("ChartReportItemQueryImpl.log.UnableToLocate"));
                return;
            }
        }
        this.cm = (Chart)((ChartReportItemImpl)item).getProperty("chart.instance");
        this.eih = eih;
    }

    public IDataQueryDefinition[] createReportQueries(IDataQueryDefinition parent) throws BirtException {
        logger.log(1, Messages.getString("ChartReportItemQueryImpl.log.getReportQueries.start"));
        if (this.cm == null) {
            return null;
        }
        IDataQueryDefinition idqd = this.createQuery(this.eih, parent);
        logger.log(1, Messages.getString("ChartReportItemQueryImpl.log.getReportQueries.end"));
        if (idqd instanceof IQueryDefinition) {
            ((IQueryDefinition)idqd).getQueryExecutionHints().setEnablePushDown(this.eih.pushDown());
        }
        return new IDataQueryDefinition[]{idqd};
    }

    IDataQueryDefinition createQuery(ExtendedItemHandle handle, IDataQueryDefinition parent) throws BirtException {
        IModelAdapter modelAdapter = this.context.getDataRequestSession().getModelAdaptor();
        if (ChartReportItemHelper.instance().getBindingDataSetHandle((ReportItemHandle)handle) != null || ChartReportItemHelper.instance().getBindingCubeHandle((ReportItemHandle)handle) == null && parent instanceof IBaseQueryDefinition) {
            ReportItemHandle itemHandle = null;
            if (ChartItemUtil.isChartInheritGroups((ReportItemHandle)handle)) {
                DesignElementHandle container = handle.getContainer();
                while (container != null) {
                    if (container instanceof ListingHandle) {
                        itemHandle = (ListingHandle)container;
                        return new ChartSharingQueryHelper((ReportItemHandle)handle, this.cm, modelAdapter).createQuery(parent);
                    }
                    container = container.getContainer();
                }
            } else {
                itemHandle = ChartItemUtil.getReportItemReference((ReportItemHandle)handle);
            }
            if (itemHandle != null) {
                return new ChartSharingQueryHelper(itemHandle, this.cm, modelAdapter).createQuery(parent);
            }
            return ChartReportItemUtil.instanceQueryHelper(handle, this.cm, modelAdapter).createBaseQuery(parent);
        }
        if (ChartReportItemHelper.instance().getBindingCubeHandle((ReportItemHandle)handle) != null || parent instanceof ICubeQueryDefinition) {
            if (handle.getContainer() instanceof MultiViewsHandle) {
                ExtendedItemHandle bindingHandle = (ExtendedItemHandle)ChartItemUtil.getReportItemReference((ReportItemHandle)handle);
                ICubeQueryDefinition cubeQuery = CrosstabQueryUtil.createCubeQuery((CrosstabReportItemHandle)((CrosstabReportItemHandle)bindingHandle.getReportItem()), (IDataQueryDefinition)parent, (IModelAdapter)modelAdapter, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
                return cubeQuery;
            }
            return ChartReportItemUtil.instanceCubeQueryHelper(handle, this.cm, modelAdapter).createCubeQuery(parent);
        }
        return null;
    }
}

