/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.aggregation.calculator.CalculatorFactory;
import org.eclipse.birt.data.aggregation.calculator.ICalculator;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrException;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.RunningAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalRunningNpv
extends AggrFunction {
    public String getName() {
        return "RUNNINGNPV";
    }

    public int getType() {
        return 1;
    }

    public int getDataType() {
        return 3;
    }

    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, ""), new ParameterDefn("rate", Messages.getString("TotalRunningNpv.param.rate"), true, false, SupportedDataTypes.CALCULATABLE, "")};
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator(CalculatorFactory.getCalculator(this.getDataType()));
    }

    public String getDescription() {
        return Messages.getString("TotalRunningNpv.description");
    }

    public String getDisplayName() {
        return Messages.getString("TotalRunningNpv.displayName");
    }

    private static class MyAccumulator
    extends RunningAccumulator {
        private Object npv = null;
        private double rate = 0.0;
        private int count = 1;

        MyAccumulator(ICalculator calc) {
            super(calc);
        }

        public void start() throws DataException {
            super.start();
            this.npv = null;
            this.count = 1;
        }

        public void onRow(Object[] args) throws DataException {
            assert (args.length > 0);
            if (args[0] != null) {
                try {
                    if (this.count == 1) {
                        this.rate = args[1] != null ? DataTypeUtil.toDouble((Object)args[1]).doubleValue() : DataTypeUtil.toDouble((Object)0).doubleValue();
                    }
                    this.npv = this.calculator.add(this.npv, this.calculator.divide(this.calculator.getTypedObject(args[0]), this.calculator.getTypedObject(Math.pow(1.0 + this.rate, this.count++))));
                }
                catch (BirtException e) {
                    throw DataException.wrap((BirtException)new AggrException("aggregation.DataConversionError", e));
                }
            }
        }

        public Object getValue() {
            return this.count > 1 ? this.npv : null;
        }
    }
}

