/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.configuration;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.apache.axis.AxisEngine;
import org.apache.axis.ConfigurationException;
import org.apache.axis.configuration.DelegatingWSDDEngineConfiguration;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.deployment.wsdd.WSDDGlobalConfiguration;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DirProvider
extends DelegatingWSDDEngineConfiguration {
    protected static Log log = LogFactory.getLog((String)DirProvider.class.getName());
    private WSDDDeployment deployment = null;
    private String configFile;
    private File dir;
    private static final String SERVER_CONFIG_FILE = "server-config.wsdd";

    public DirProvider(String basepath) throws ConfigurationException {
        this(basepath, SERVER_CONFIG_FILE);
    }

    public DirProvider(String basepath, String configFile) throws ConfigurationException {
        File dir = new File(basepath);
        if (!(dir.exists() && dir.isDirectory() && dir.canRead())) {
            throw new ConfigurationException(Messages.getMessage("invalidConfigFilePath", basepath));
        }
        this.dir = dir;
        this.configFile = configFile;
    }

    public WSDDDeployment getDeployment() {
        return this.deployment;
    }

    public void configureEngine(AxisEngine engine) throws ConfigurationException {
        this.deployment = new WSDDDeployment();
        WSDDGlobalConfiguration config = new WSDDGlobalConfiguration();
        config.setOptionsHashtable(new Hashtable());
        this.deployment.setGlobalConfiguration(config);
        File[] dirs = this.dir.listFiles(new DirFilter());
        for (int i = 0; i < dirs.length; ++i) {
            this.processWSDD(dirs[i]);
        }
        this.deployment.configureEngine(engine);
        engine.refreshGlobalOptions();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processWSDD(File dir) throws ConfigurationException {
        File file = new File(dir, this.configFile);
        if (!file.exists()) {
            return;
        }
        log.debug((Object)("Loading service configuration from file: " + file));
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(file);
                WSDDDocument doc = new WSDDDocument(XMLUtils.newDocument(in));
                doc.deploy(this.deployment);
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
            Object var6_6 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (in == null) throw throwable;
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        ((InputStream)in).close();
        return;
    }

    public void writeEngineConfig(AxisEngine engine) throws ConfigurationException {
    }

    private static class DirFilter
    implements FileFilter {
        private DirFilter() {
        }

        public boolean accept(File path) {
            return path.isDirectory();
        }
    }
}

