/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.timer;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.timer.TimerFactory;

public class SingletonTimerFactory
implements TimerFactory,
ModuleControl {
    private Timer singletonTimer;
    private final AtomicInteger cancelCount = new AtomicInteger();

    public SingletonTimerFactory() {
        ClassLoader classLoader = SingletonTimerFactory.getContextClassLoader();
        if (classLoader != null) {
            SingletonTimerFactory.setContextClassLoader(null);
        }
        this.singletonTimer = new Timer(true);
        if (classLoader != null) {
            SingletonTimerFactory.setContextClassLoader(classLoader);
        }
    }

    @Override
    public void schedule(TimerTask timerTask, long l) {
        this.singletonTimer.schedule(timerTask, l);
    }

    @Override
    public void cancel(TimerTask timerTask) {
        timerTask.cancel();
        if (this.cancelCount.incrementAndGet() % 1000 == 0) {
            this.singletonTimer.purge();
        }
    }

    @Override
    public void boot(boolean bl, Properties properties) throws StandardException {
    }

    @Override
    public void stop() {
        this.singletonTimer.cancel();
    }

    private static ClassLoader getContextClassLoader() {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    private static void setContextClassLoader(final ClassLoader classLoader) {
        try {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

