/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util.filter;

import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.util.CompareUtil;
import org.eclipse.birt.data.engine.olap.util.IJSObjectPopulator;
import org.eclipse.birt.data.engine.olap.util.filter.BaseDimensionFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IJSDimensionFilterHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IResultRow;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Scriptable;

public class DimensionFilterEvalHelper
extends BaseDimensionFilterEvalHelper
implements IJSDimensionFilterHelper {
    public DimensionFilterEvalHelper(IBaseQueryResults outResults, Scriptable parentScope, ScriptContext cx, ICubeQueryDefinition queryDefn, IFilterDefinition cubeFilter) throws DataException {
        assert (cubeFilter != null);
        this.initialize(outResults, parentScope, queryDefn, cubeFilter, cx);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean evaluateFilter(IResultRow resultRow) throws DataException {
        super.setData(resultRow);
        try {
            if (this.isAxisFilter) {
                int i = 0;
                while (i < this.axisLevels.length) {
                    DimLevel level = new DimLevel(this.axisLevels[i]);
                    if (CompareUtil.compare(resultRow.getFieldValue(level.toString()), this.axisValues[i]) != 0) {
                        return false;
                    }
                    ++i;
                }
            }
            Object result = ScriptEvalUtil.evalExpr(this.expr, this.cx.newContext((Object)this.scope), ScriptExpression.defaultID, 0);
            return DataTypeUtil.toBoolean((Object)result);
        }
        catch (IJSObjectPopulator.InMatchDimensionIndicator e) {
            return true;
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }
}

