/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;

public final class WordWidth {
    private static final String SOFT_HYPHEN = "\u00ad";
    public final int width;
    public final int softHyphenWidth;

    public WordWidth(FontInfo fontInfo, String text) {
        int _width = WordWidth.getTextWidth(fontInfo, text);
        if (text.endsWith(SOFT_HYPHEN)) {
            this.softHyphenWidth = WordWidth.getTextWidth(fontInfo, "-");
            this.width = _width - WordWidth.getTextWidth(fontInfo, SOFT_HYPHEN);
        } else {
            this.width = _width;
            this.softHyphenWidth = 0;
        }
    }

    public WordWidth(int width, int softHyphenWidth) {
        this.width = width;
        this.softHyphenWidth = softHyphenWidth;
    }

    public static int getTextWidth(FontInfo fontInfo, String text) {
        return (int)(fontInfo.getWordWidth(text) * 1000.0f);
    }
}

