/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.nLayout.area.IContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockContainerArea;

public class RegionArea
extends BlockContainerArea
implements IContainerArea {
    public RegionArea() {
    }

    RegionArea(RegionArea area) {
        super(area);
    }

    @Override
    public void initialize() throws BirtException {
        this.calculateSpecifiedWidth(this.content);
        this.calculateSpecifiedHeight(this.content);
    }

    @Override
    protected void calculateSpecifiedHeight(IContent content) {
        if (content == null) {
            return;
        }
        DimensionType height = content.getHeight();
        if (height != null) {
            this.specifiedHeight = this.getDimensionValue(content, height, this.parent.getHeight());
        }
    }

    @Override
    public void close() {
        if (this.context.isFixedLayout()) {
            this.setContentHeight(this.specifiedHeight);
        } else {
            this.setContentHeight(Math.max(this.specifiedHeight, this.currentBP));
        }
        this.finished = true;
    }

    @Override
    public void update(AbstractArea area) throws BirtException {
        int aHeight = area.getAllocatedHeight();
        this.currentBP += aHeight;
        if (this.currentIP + area.getAllocatedWidth() > this.maxAvaWidth) {
            this.setNeedClip(true);
        }
    }
}

