/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import com.ibm.icu.util.ULocale;
import java.util.Iterator;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.value.DataFormatValue;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.area.IContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.LogicContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.PageArea;
import org.eclipse.birt.report.engine.layout.pdf.emitter.BlockStackingLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ContainerLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.Layout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEmitterAdapter;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.emitter.RegionLayout;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public class PageLayout
extends BlockStackingLayout {
    static final int DEFAULT_PAGE_WIDTH = 595275;
    static final int DEFAULT_PAGE_HEIGHT = 841889;
    protected IReportContent report;
    protected IPageContent pageContent;
    protected IReportExecutor reportExecutor = null;
    protected IContentEmitter emitter;
    private int pageContentWidth = 595275;
    private int pageContentHeight = 841889;
    private int rootWidth;
    private int rootHeight;
    private int rootLeft;
    private int rootTop;
    protected MasterPageDesign masterPage = null;

    public PageLayout(IReportExecutor executor, LayoutEngineContext context, ContainerLayout parent, IContent content) {
        super(context, parent, content);
        this.reportExecutor = executor;
        this.pageContent = (IPageContent)content;
        this.masterPage = (MasterPageDesign)this.pageContent.getGenerateBy();
        this.report = this.pageContent.getReportContent();
    }

    @Override
    protected void initialize() throws BirtException {
        PageContext pageContext = new PageContext();
        if (this.context.autoPageBreak) {
            ++this.context.pageNumber;
            pageContext.pageContent = this.createPageContent(this.pageContent);
        } else {
            pageContext.pageContent = this.pageContent;
        }
        this.currentContext = pageContext;
        this.contextList.add(this.currentContext);
        this.createRoot();
        PageArea page = (PageArea)this.currentContext.root;
        this.context.setMaxHeight(page.getRoot().getHeight());
        this.context.setMaxWidth(page.getRoot().getWidth());
        this.layoutHeader(page);
        this.layoutFooter(page);
        this.updateBodySize(page);
        this.context.setMaxHeight(page.getBody().getHeight());
        this.context.setMaxWidth(page.getBody().getWidth());
        this.currentContext.maxAvaWidth = this.context.getMaxWidth();
        this.currentContext.maxAvaHeight = this.context.autoPageBreak ? this.context.getMaxHeight() : Integer.MAX_VALUE;
    }

    protected void updateBodySize(PageArea page) {
        IContainerArea header = page.getHeader();
        ContainerArea footer = (ContainerArea)page.getFooter();
        ContainerArea body = (ContainerArea)page.getBody();
        ContainerArea root = (ContainerArea)page.getRoot();
        if (header != null && header.getHeight() >= root.getHeight()) {
            page.removeHeader();
            header = null;
        }
        if (footer != null && footer.getHeight() >= root.getHeight()) {
            page.removeHeader();
            footer = null;
        }
        if (header != null && footer != null && footer.getHeight() + header.getHeight() >= root.getHeight()) {
            page.removeFooter();
            page.removeHeader();
            header = null;
            footer = null;
        }
        body.setHeight(root.getHeight() - (header == null ? 0 : header.getHeight()) - (footer == null ? 0 : footer.getHeight()));
        body.setPosition(body.getX(), header == null ? 0 : header.getHeight());
        if (footer != null) {
            footer.setPosition(footer.getX(), (header == null ? 0 : header.getHeight()) + (body == null ? 0 : body.getHeight()));
        }
    }

    protected void layoutHeader(PageArea page) throws BirtException {
        IContent headerContent = ((PageContext)this.currentContext).pageContent.getPageHeader();
        RegionLayout regionLayout = new RegionLayout(this.context, headerContent, page.getHeader());
        ((Layout)regionLayout).layout();
    }

    protected void layoutFooter(PageArea page) throws BirtException {
        IContent footerContent = ((PageContext)this.currentContext).pageContent.getPageFooter();
        RegionLayout regionLayout = new RegionLayout(this.context, footerContent, page.getFooter());
        ((Layout)regionLayout).layout();
    }

    public void floatingFooter(PageArea page) {
        ContainerArea footer = (ContainerArea)page.getFooter();
        IContainerArea body = page.getBody();
        IContainerArea header = page.getHeader();
        if (footer != null) {
            footer.setPosition(footer.getX(), (header == null ? 0 : header.getHeight()) + (body == null ? 0 : body.getHeight()));
        }
    }

    @Override
    protected void createRoot() {
        this.currentContext.root = new PageArea(((PageContext)this.currentContext).pageContent);
        PageArea page = (PageArea)this.currentContext.root;
        int overFlowType = this.context.getPageOverflow();
        this.pageContentWidth = this.getDimensionValue(this.pageContent.getPageWidth());
        this.pageContentHeight = this.getDimensionValue(this.pageContent.getPageHeight());
        if (this.pageContentWidth <= 0) {
            this.pageContentWidth = 595275;
        }
        if (this.pageContentHeight <= 0) {
            this.pageContentHeight = 841889;
        }
        page.setWidth(this.pageContentWidth);
        page.setHeight(this.pageContentHeight);
        ContainerArea pageRoot = (ContainerArea)AreaFactory.createBlockContainer(this.pageContent);
        this.rootLeft = this.getDimensionValue(this.pageContent.getMarginLeft(), this.pageContentWidth);
        this.rootTop = this.getDimensionValue(this.pageContent.getMarginTop(), this.pageContentWidth);
        this.rootLeft = Math.max(0, this.rootLeft);
        this.rootLeft = Math.min(this.pageContentWidth, this.rootLeft);
        this.rootTop = Math.max(0, this.rootTop);
        this.rootTop = Math.min(this.pageContentHeight, this.rootTop);
        pageRoot.setPosition(this.rootLeft, this.rootTop);
        int rootRight = this.getDimensionValue(this.pageContent.getMarginRight(), this.pageContentWidth);
        int rootBottom = this.getDimensionValue(this.pageContent.getMarginBottom(), this.pageContentWidth);
        rootRight = Math.max(0, rootRight);
        rootBottom = Math.max(0, rootBottom);
        if (this.rootLeft + rootRight > this.pageContentWidth) {
            rootRight = 0;
        }
        if (this.rootTop + rootBottom > this.pageContentHeight) {
            rootBottom = 0;
        }
        this.rootWidth = this.pageContentWidth - this.rootLeft - rootRight;
        this.rootHeight = this.pageContentHeight - this.rootTop - rootBottom;
        pageRoot.setWidth(this.rootWidth);
        pageRoot.setHeight(this.rootHeight);
        page.setRoot(pageRoot);
        int headerHeight = this.getDimensionValue(this.pageContent.getHeaderHeight(), pageRoot.getHeight());
        int headerWidth = pageRoot.getWidth();
        IStyle pageStyle = this.pageContent.getComputedStyle();
        int topBorderWidth = PropertyUtil.getDimensionValue(pageStyle.getProperty(27));
        int bottomBorderWidth = PropertyUtil.getDimensionValue(pageStyle.getProperty(10));
        int leftBorderWidth = PropertyUtil.getDimensionValue(pageStyle.getProperty(50));
        int rightBorderWidth = PropertyUtil.getDimensionValue(pageStyle.getProperty(9));
        int horizontalBorderWidth = leftBorderWidth + rightBorderWidth;
        headerHeight = Math.max(0, headerHeight);
        headerHeight = Math.min(pageRoot.getHeight(), headerHeight);
        LogicContainerArea header = new LogicContainerArea(this.report);
        header.setHeight(headerHeight - topBorderWidth);
        header.setWidth(headerWidth - horizontalBorderWidth);
        header.setPosition(leftBorderWidth, topBorderWidth);
        pageRoot.addChild(header);
        page.setHeader(header);
        int footerHeight = this.getDimensionValue(this.pageContent.getFooterHeight(), pageRoot.getHeight());
        int footerWidth = pageRoot.getWidth();
        footerHeight = Math.max(0, footerHeight);
        footerHeight = Math.min(pageRoot.getHeight() - headerHeight, footerHeight);
        LogicContainerArea footer = new LogicContainerArea(this.report);
        footer.setHeight(footerHeight - bottomBorderWidth);
        footer.setWidth(footerWidth - horizontalBorderWidth);
        footer.setPosition(leftBorderWidth, pageRoot.getHeight() - footerHeight - bottomBorderWidth);
        pageRoot.addChild(footer);
        page.setFooter(footer);
        LogicContainerArea body = new LogicContainerArea(this.report);
        int bodyLeft = this.getDimensionValue(this.pageContent.getLeftWidth(), pageRoot.getWidth());
        bodyLeft = Math.max(0, bodyLeft);
        bodyLeft = Math.min(pageRoot.getWidth(), bodyLeft);
        body.setPosition(bodyLeft + leftBorderWidth, headerHeight);
        int bodyRight = this.getDimensionValue(this.pageContent.getRightWidth(), pageRoot.getWidth());
        bodyRight = Math.max(0, bodyRight);
        bodyRight = Math.min(pageRoot.getWidth() - bodyLeft, bodyRight);
        body.setWidth(pageRoot.getWidth() - bodyLeft - bodyRight - horizontalBorderWidth);
        body.setHeight(pageRoot.getHeight() - headerHeight - footerHeight);
        page.setBody(body);
        pageRoot.addChild(body);
        if (overFlowType == 1 || overFlowType == 4) {
            pageRoot.setNeedClip(true);
            page.getBody().setNeedClip(true);
        } else {
            pageRoot.setNeedClip(false);
        }
    }

    @Override
    protected void closeLayout(ContainerLayout.ContainerContext currentContext, int index, boolean finished) throws BirtException {
        PageArea page = (PageArea)currentContext.root;
        int overFlowType = this.context.getPageOverflow();
        this.context.setFinished(finished);
        if (overFlowType == 2) {
            float scale = this.calculatePageScale(currentContext, page);
            if (1.0f == scale) {
                ((PageContext)currentContext).pageContent.setExtension(1, page);
                this.outputPage(((PageContext)currentContext).pageContent);
                return;
            }
            page.setScale(scale);
            this.updatePageDimension(scale, page);
        } else if (overFlowType == 8) {
            this.updatePageDimension(page);
        }
        ((PageContext)currentContext).pageContent.setExtension(1, page);
        this.outputPage(((PageContext)currentContext).pageContent);
        if (this.contextList.size() > 0) {
            this.currentContext = (ContainerLayout.ContainerContext)this.contextList.get(0);
        }
    }

    @Override
    public boolean isPageEmpty() {
        IContainerArea body;
        PageArea page = (PageArea)this.currentContext.root;
        return page == null || (body = page.getBody()).getChildrenCount() <= 0;
    }

    public void outputPage(IPageContent page) throws BirtException {
        LayoutEmitterAdapter emitter = this.context.emitter;
        emitter.outputPage(page);
        ILayoutPageHandler pageHandler = emitter.getPageHandler();
        if (pageHandler != null) {
            pageHandler.onPage(this.context.pageNumber, this.context);
        }
    }

    private float calculatePageScale(ContainerLayout.ContainerContext currentContext, PageArea page) {
        float scale = 1.0f;
        if (page != null && page.getRoot().getChildrenCount() > 0) {
            int maxWidth = this.context.getMaxWidth();
            int maxHeight = this.context.getMaxHeight();
            int prefWidth = this.context.getPreferenceWidth();
            int prefHeight = currentContext.currentBP;
            Iterator<?> iter = page.getBody().getChildren();
            while (iter.hasNext()) {
                AbstractArea area = (AbstractArea)iter.next();
                prefWidth = Math.max(prefWidth, area.getAllocatedX() + area.getAllocatedWidth());
            }
            if (prefHeight > maxHeight) {
                ((ContainerArea)page.getBody()).setHeight(prefHeight);
                this.floatingFooter(page);
            }
            if (prefWidth > maxWidth || prefHeight > maxHeight) {
                scale = Math.min((float)maxWidth / (float)prefWidth, (float)maxHeight / (float)prefHeight);
            }
        }
        return scale;
    }

    protected void updatePageDimension(float scale, PageArea page) {
        page.setHeight((int)((float)this.pageContentHeight / scale));
        page.setWidth((int)((float)this.pageContentWidth / scale));
        ContainerArea pageRoot = (ContainerArea)page.getRoot();
        pageRoot.setPosition((int)((float)this.rootLeft / scale), (int)((float)this.rootTop / scale));
        pageRoot.setHeight((int)((float)this.rootHeight / scale));
        pageRoot.setWidth((int)((float)this.rootWidth / scale));
    }

    protected void updatePageDimension(PageArea page) {
        if (page != null && page.getRoot().getChildrenCount() > 0) {
            ContainerArea pageRoot;
            int maxWidth = this.context.getMaxWidth();
            int maxHeight = this.context.getMaxHeight();
            int prefWidth = this.context.getPreferenceWidth();
            int prefHeight = this.currentContext.currentBP;
            Iterator<?> iter = page.getBody().getChildren();
            while (iter.hasNext()) {
                AbstractArea area = (AbstractArea)iter.next();
                prefWidth = Math.max(prefWidth, area.getAllocatedX() + area.getAllocatedWidth());
            }
            if (prefHeight > maxHeight) {
                ((ContainerArea)page.getBody()).setHeight(prefHeight);
                this.floatingFooter(page);
                int deltaHeight = prefHeight - maxHeight;
                pageRoot = (ContainerArea)page.getRoot();
                pageRoot.setHeight(pageRoot.getHeight() + deltaHeight);
                page.setHeight(this.pageContentHeight + deltaHeight);
            }
            if (prefWidth > maxWidth) {
                ((ContainerArea)page.getBody()).setWidth(prefWidth);
                int deltaWidth = prefWidth - maxWidth;
                pageRoot = (ContainerArea)page.getRoot();
                pageRoot.setWidth(pageRoot.getWidth() + deltaWidth);
                page.setWidth(this.pageContentWidth + deltaWidth);
            }
        }
    }

    @Override
    public void addToRoot(AbstractArea area) {
        this.currentContext.root.addChild(area);
        area.setAllocatedPosition(this.currentContext.currentIP + this.offsetX, this.currentContext.currentBP + this.offsetY);
        this.currentContext.currentBP += area.getAllocatedHeight();
        assert (this.currentContext.root instanceof PageArea);
        AbstractArea body = (AbstractArea)((Object)((PageArea)this.currentContext.root).getBody());
        if (this.currentContext.currentIP + area.getAllocatedWidth() > this.currentContext.root.getContentWidth() - body.getX()) {
            this.currentContext.root.setNeedClip(true);
        }
        if (this.currentContext.currentBP > this.currentContext.maxAvaHeight) {
            this.currentContext.root.setNeedClip(true);
        }
    }

    protected IPageContent createPageContent(IPageContent htmlPageContent) {
        if (this.context.pageNumber == htmlPageContent.getPageNumber()) {
            return htmlPageContent;
        }
        IPageContent pageContent = this.createPageContent(htmlPageContent, this.context.pageNumber, this.context.totalPage);
        return pageContent;
    }

    protected IPageContent createPageContent(IPageContent pageContent, long pageNumber, long totalPageNumber) {
        return (IPageContent)this.cloneContent(pageContent, pageNumber, totalPageNumber);
    }

    protected IContent cloneContent(IContent content, long pageNumber, long totalPageNumber) {
        IAutoTextContent autoText;
        int type;
        IContent newContent = content.cloneContent(false);
        if (newContent.getContentType() == 12 && ((type = (autoText = (IAutoTextContent)newContent).getType()) == 1 || type == 3)) {
            DataFormatValue format = autoText.getComputedStyle().getDataFormat();
            NumberFormatter nf = null;
            if (format == null) {
                nf = new NumberFormatter();
            } else {
                String pattern = format.getNumberPattern();
                String locale = format.getNumberLocale();
                nf = locale == null ? new NumberFormatter(pattern) : new NumberFormatter(pattern, new ULocale(locale));
            }
            autoText.setText(nf.format(pageNumber));
        }
        for (IContent child : content.getChildren()) {
            IContent newChild = this.cloneContent(child, pageNumber, totalPageNumber);
            newChild.setParent(newContent);
            newContent.getChildren().add(newChild);
        }
        return newContent;
    }

    protected MasterPageDesign getMasterPage(IReportContent report) {
        if (this.masterPage != null) {
            return this.masterPage;
        }
        return this.getDefaultMasterPage(report);
    }

    protected MasterPageDesign getDefaultMasterPage(IReportContent report) {
        PageSetupDesign pageSetup = report.getDesign().getPageSetup();
        int pageCount = pageSetup.getMasterPageCount();
        if (pageCount > 0) {
            MasterPageDesign pageDesign = pageSetup.getMasterPage(0);
            return pageDesign;
        }
        return null;
    }

    class PageContext
    extends ContainerLayout.ContainerContext {
        IPageContent pageContent;

        PageContext() {
        }
    }
}

