/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.content;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.extension.ReportItemExecutorBase;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.layout.content.ItemExecutorWrapper;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.w3c.dom.css.CSSValue;

public class RunInContainerExecutor
extends ReportItemExecutorBase {
    protected IReportItemExecutor executor;
    protected IContent content;
    protected LinkedList children = new LinkedList();

    public RunInContainerExecutor(IReportItemExecutor executor, IContent content) throws BirtException {
        this.executor = executor;
        this.content = content;
        boolean first = true;
        while (executor.hasNextChild()) {
            IReportItemExecutor childExecutor = executor.getNextChild();
            IContent childContent = childExecutor.execute();
            if (childContent == null) continue;
            if (first) {
                this.transferPageBreak(content, childContent);
                first = false;
            }
            if (PropertyUtil.isInlineElement(childContent)) {
                this.execute(childExecutor, childContent);
                childExecutor.close();
                this.children.addLast(new DOMReportItemExecutor(childContent));
                continue;
            }
            this.children.addLast(new ItemExecutorWrapper(childExecutor, childContent));
            break;
        }
    }

    @Override
    public void close() throws BirtException {
        this.executor.close();
    }

    @Override
    public IContent execute() {
        return this.content;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IReportItemExecutor getNextChild() throws BirtException {
        if (this.children.size() <= 0) ** GOTO lbl13
        return (IReportItemExecutor)this.children.removeFirst();
lbl-1000:
        // 1 sources

        {
            childExecutor = this.executor.getNextChild();
            childContent = childExecutor.execute();
            if (childContent == null) continue;
            if (PropertyUtil.isInlineElement(childContent)) {
                this.execute(childExecutor, childContent);
                childExecutor.close();
                this.children.addLast(new DOMReportItemExecutor(childContent));
                continue;
            }
            this.children.addLast(new ItemExecutorWrapper(childExecutor, childContent));
            break;
lbl13:
            // 3 sources

            ** while (this.executor.hasNextChild())
        }
lbl14:
        // 2 sources

        if (this.children.size() > 0) {
            return (IReportItemExecutor)this.children.removeFirst();
        }
        return null;
    }

    @Override
    public boolean hasNextChild() throws BirtException {
        return this.children.size() > 0 || this.executor.hasNextChild();
    }

    protected void execute(IReportItemExecutor executor, IContent content) throws BirtException {
        while (executor.hasNextChild()) {
            IReportItemExecutor childExecutor = executor.getNextChild();
            if (childExecutor == null) continue;
            IContent childContent = childExecutor.execute();
            this.add(content.getChildren(), childContent);
            this.execute(childExecutor, childContent);
            childExecutor.close();
        }
    }

    private void add(Collection collection, IContent content) {
        if (!collection.contains(content)) {
            collection.add(content);
        }
    }

    protected void transferPageBreak(IContent parent, IContent child) {
        if (parent != null && child != null) {
            IStyle childStyle = child.getStyle();
            IStyle parentStyle = parent.getStyle();
            CSSValue parentPageBreak = parentStyle.getProperty(30);
            if (IStyle.ALWAYS_VALUE.equals(parentPageBreak) || IStyle.SOFT_VALUE.equals(parentPageBreak)) {
                childStyle.setProperty(30, IStyle.ALWAYS_VALUE);
            }
        }
    }
}

