/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.ArrayList;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.executor.MasterPageExecutor;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;

public class PageBandExecutor
extends ReportItemExecutor {
    private ArrayList contents;
    private int nextItem;

    protected PageBandExecutor(MasterPageExecutor parent, ArrayList contents) {
        super(parent.manager, -1);
        this.parent = parent;
        this.contents = contents;
        this.nextItem = 0;
    }

    @Override
    public void close() throws BirtException {
        this.nextItem = 0;
        this.contents = null;
        super.close();
    }

    @Override
    public IContent execute() {
        this.content = this.report.createContainerContent();
        this.initializeContent(null, this.content);
        return this.content;
    }

    @Override
    public boolean hasNextChild() {
        return this.nextItem < this.contents.size();
    }

    @Override
    public IReportItemExecutor getNextChild() {
        int itemCount = this.contents.size();
        if (this.nextItem < itemCount) {
            ReportItemDesign itemDesign = (ReportItemDesign)this.contents.get(this.nextItem);
            ++this.nextItem;
            return this.manager.createExecutor(this, itemDesign);
        }
        return null;
    }
}

