/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.GroupExecutor;
import org.eclipse.birt.report.engine.executor.ListBandExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.ListGroupDesign;

public class ListGroupExecutor
extends GroupExecutor {
    protected ListGroupExecutor(ExecutorManager manager) {
        super(manager, 15);
    }

    @Override
    public void close() throws BirtException {
        this.handlePageBreakAfterExclusingLast();
        this.handlePageBreakAfter();
        this.finishGroupTOCEntry();
        super.close();
    }

    @Override
    public IContent execute() {
        ListGroupDesign groupDesign = (ListGroupDesign)this.getDesign();
        IListGroupContent groupContent = this.report.createListGroupContent();
        this.setContent(groupContent);
        this.restoreResultSet();
        this.initializeContent(groupDesign, groupContent);
        this.processBookmark(groupDesign, groupContent);
        this.handlePageBreakInsideOfGroup();
        this.handlePageBreakBeforeOfGroup();
        this.handlePageBreakAfterOfGroup();
        this.handlePageBreakAfterOfPreviousGroup();
        this.handlePageBreakBefore();
        this.handlePageBreakInterval();
        if (this.context.isInFactory()) {
            this.handleOnCreate(groupContent);
        }
        this.startGroupTOCEntry(groupContent);
        this.prepareToExecuteChildren();
        return groupContent;
    }

    @Override
    public IReportItemExecutor getNextChild() {
        IReportItemExecutor executor = super.getNextChild();
        if (executor instanceof ListBandExecutor) {
            ListBandExecutor bandExecutor = (ListBandExecutor)executor;
            bandExecutor.setListingExecutor(this.listingExecutor);
        }
        return executor;
    }
}

