/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.impl.Column;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.executor.RowExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;

public class GridItemExecutor
extends QueryItemExecutor {
    int curRowDesign;
    int curRowContent;

    public GridItemExecutor(ExecutorManager manager) {
        super(manager, 0);
    }

    @Override
    public IContent execute() {
        GridItemDesign gridDesign = (GridItemDesign)this.getDesign();
        ITableContent tableContent = this.report.createTableContent();
        this.setContent(tableContent);
        this.executeQuery();
        this.initializeContent(gridDesign, tableContent);
        this.processAction(gridDesign, tableContent);
        this.processBookmark(gridDesign, tableContent);
        this.processStyle(gridDesign, tableContent);
        this.processVisibility(gridDesign, tableContent);
        this.processUserProperties(gridDesign, tableContent);
        int i = 0;
        while (i < gridDesign.getColumnCount()) {
            ColumnDesign columnDesign = gridDesign.getColumn(i);
            Column column = new Column(this.report);
            column.setGenerateBy(columnDesign);
            InstanceID iid = new InstanceID(null, columnDesign.getID(), null);
            column.setInstanceID(iid);
            this.processColumnVisibility(columnDesign, column);
            tableContent.addColumn(column);
            ++i;
        }
        if (this.context.isInFactory()) {
            this.handleOnCreate(tableContent);
        }
        this.startTOCEntry(tableContent);
        this.curRowDesign = 0;
        this.curRowContent = 0;
        return tableContent;
    }

    @Override
    public void close() throws BirtException {
        this.finishTOCEntry();
        this.closeQuery();
        super.close();
    }

    @Override
    public boolean hasNextChild() {
        GridItemDesign gridDesign = (GridItemDesign)this.getDesign();
        return this.curRowDesign < gridDesign.getRowCount();
    }

    @Override
    public IReportItemExecutor getNextChild() {
        GridItemDesign gridDesign = (GridItemDesign)this.getDesign();
        if (this.curRowDesign < gridDesign.getRowCount()) {
            RowDesign rowDesign;
            ReportItemExecutor childExecutor;
            if ((childExecutor = this.manager.createExecutor(this, rowDesign = gridDesign.getRow(this.curRowDesign++))) instanceof RowExecutor) {
                RowExecutor rowExecutor = (RowExecutor)childExecutor;
                rowExecutor.setRowId(this.curRowContent++);
            } else {
                ++this.curRowContent;
            }
            return childExecutor;
        }
        return null;
    }
}

