/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.series;

import java.util.Collection;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.birt.chart.model.attribute.impl.MarkerImpl;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.type.GanttSeries;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.model.util.DefaultValueProvider;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartCheckbox;
import org.eclipse.birt.chart.ui.swt.composites.GanttLineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.composites.MarkerEditorComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class GanttSeriesAttributeComposite
extends Composite
implements SelectionListener,
Listener {
    private transient ChartCheckbox btnPalette = null;
    private transient Group grpLine = null;
    private transient GanttLineAttributesComposite gliacGantt = null;
    private transient Group grpOutline = null;
    private transient LineAttributesComposite oliacGantt = null;
    private transient GanttSeries series = null;
    private GanttSeries defSeries = DefaultValueProvider.defGanttSeries();
    private transient ChartWizardContext context;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui.extension/swt.series");

    public GanttSeriesAttributeComposite(Composite parent, int style, ChartWizardContext context, Series series) {
        super(parent, style);
        if (!(series instanceof GanttSeries)) {
            try {
                throw new ChartException("org.eclipse.birt.chart.ui.extension", 30, "GanttSeriesAttributeComposite.Exception.IllegalArgument", new Object[]{series.getClass().getName()}, Messages.getResourceBundle());
            }
            catch (ChartException e) {
                logger.log((Exception)((Object)e));
                e.printStackTrace();
            }
        }
        this.series = (GanttSeries)series;
        this.context = context;
        this.init();
        this.placeComponents();
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatGanttChartYSeries_ID");
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
    }

    private void placeComponents() {
        GridLayout glContent = new GridLayout(2, false);
        glContent.marginHeight = 2;
        glContent.marginWidth = 2;
        glContent.horizontalSpacing = 0;
        this.setLayout((Layout)glContent);
        Composite cmpMarker = new Composite((Composite)this, 0);
        cmpMarker.setLayout((Layout)new GridLayout());
        cmpMarker.setLayoutData((Object)new GridData(1808));
        Group grpMarker = new Group(cmpMarker, 0);
        grpMarker.setText(Messages.getString("GanttSeriesAttributeComposite.Lbl.Marker"));
        grpMarker.setLayout((Layout)new GridLayout(2, false));
        grpMarker.setLayoutData((Object)new GridData(1808));
        Label lblStart = new Label((Composite)grpMarker, 0);
        lblStart.setText(Messages.getString("GanttSeriesAttributeComposite.Lbl.Start"));
        new MarkerEditorComposite((Composite)grpMarker, this.createMarker(this.series.getStartMarker()), this.context, this.defSeries.getStartMarker());
        Label lblEnd = new Label((Composite)grpMarker, 0);
        lblEnd.setText(Messages.getString("GanttSeriesAttributeComposite.Lbl.End"));
        new MarkerEditorComposite((Composite)grpMarker, this.createMarker(this.series.getEndMarker()), this.context, this.defSeries.getEndMarker());
        Composite cmpGroup = new Composite((Composite)this, 0);
        GridLayout glGroup = new GridLayout(2, true);
        glGroup.marginWidth = 0;
        glGroup.horizontalSpacing = 6;
        cmpGroup.setLayout((Layout)glGroup);
        cmpGroup.setLayoutData((Object)new GridData(1808));
        this.grpLine = new Group(cmpGroup, 0);
        GridData gdGRPLine = new GridData(1808);
        this.grpLine.setLayout((Layout)new GridLayout(1, false));
        this.grpLine.setLayoutData((Object)gdGRPLine);
        this.grpLine.setText(Messages.getString("GanttSeriesAttributeComposite.Lbl.Bars"));
        this.gliacGantt = new GanttLineAttributesComposite((Composite)this.grpLine, this.context, 0, this.series.getConnectionLine(), this.getLineOptionalStyles(), DefaultValueProvider.defGanttSeries().getConnectionLine());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.gliacGantt.setLayoutData(gd);
        this.gliacGantt.addListener(this);
        this.btnPalette = this.context.getUIFactory().createChartCheckbox((Composite)this.grpLine, 0, this.defSeries.isPaletteLineColor());
        this.btnPalette.setText(Messages.getString("GanttSeriesAttributeComposite.Lbl.BarPalette"));
        gd = new GridData(768);
        gd.horizontalIndent = 4;
        this.btnPalette.setLayoutData((Object)gd);
        this.btnPalette.setSelectionState(this.series.isSetPaletteLineColor() ? (this.series.isPaletteLineColor() ? 1 : 2) : 0);
        this.btnPalette.addSelectionListener((SelectionListener)this);
        this.grpOutline = new Group(cmpGroup, 0);
        GridData gdGRPOutline = new GridData(1808);
        this.grpOutline.setLayout((Layout)new FillLayout());
        this.grpOutline.setLayoutData((Object)gdGRPOutline);
        this.grpOutline.setText(Messages.getString("GanttSeriesAttributeComposite.Lbl.Outline"));
        this.oliacGantt = new LineAttributesComposite((Composite)this.grpOutline, 0, this.getOutlineOptionalStyles(), this.context, this.series.getOutline(), this.defSeries.getOutline());
        this.oliacGantt.addListener(this);
    }

    protected int getOutlineOptionalStyles() {
        return 31;
    }

    protected int getLineOptionalStyles() {
        return 7;
    }

    public Point getPreferredSize() {
        return new Point(400, 200);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.btnPalette)) {
            ChartElementUtil.setEObjectAttribute((EObject)this.series, (String)"paletteLineColor", (Object)(this.btnPalette.getSelectionState() == 1 ? 1 : 0), (this.btnPalette.getSelectionState() == 0 ? 1 : 0) != 0);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void handleEvent(Event event) {
        boolean isUnset;
        boolean bl = isUnset = event.detail == ChartUIExtensionUtil.PROPERTY_UNSET;
        if (event.widget.equals((Object)this.gliacGantt)) {
            if (event.type == 4) {
                ChartElementUtil.setEObjectAttribute((EObject)this.series.getConnectionLine(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
                this.btnPalette.setEnabled(isUnset || (Boolean)event.data != false);
            } else if (event.type == 1) {
                ChartElementUtil.setEObjectAttribute((EObject)this.series.getConnectionLine(), (String)"style", (Object)event.data, (boolean)isUnset);
            } else if (event.type == 2) {
                ChartElementUtil.setEObjectAttribute((EObject)this.series.getConnectionLine(), (String)"thickness", (Object)((Integer)event.data), (boolean)isUnset);
            } else if (event.type == 3) {
                this.series.getConnectionLine().setColor((ColorDefinition)event.data);
            }
        } else if (event.widget.equals((Object)this.oliacGantt)) {
            if (event.type == 4) {
                ChartElementUtil.setEObjectAttribute((EObject)this.series.getOutline(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
            } else if (event.type == 1) {
                ChartElementUtil.setEObjectAttribute((EObject)this.series.getOutline(), (String)"style", (Object)event.data, (boolean)isUnset);
            } else if (event.type == 2) {
                ChartElementUtil.setEObjectAttribute((EObject)this.series.getOutline(), (String)"thickness", (Object)((Integer)event.data), (boolean)isUnset);
            } else if (event.type == 3) {
                this.series.getOutline().setColor((ColorDefinition)event.data);
            }
        }
    }

    private Marker createMarker(Marker marker) {
        if (marker == null) {
            marker = MarkerImpl.create((MarkerType)MarkerType.NABLA_LITERAL, (int)4);
            marker.eAdapters().addAll((Collection)this.series.eAdapters());
        }
        return marker;
    }
}

