/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui.dialogs;

import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExpressionDialogCellEditor
extends DialogCellEditor
implements ModifyListener {
    private DesignElementHandle itemHandle;
    private Text text;
    private Button btnPopup;

    public ExpressionDialogCellEditor(Composite parent) {
        super(parent);
    }

    public ExpressionDialogCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Control createContents(Composite cell) {
        Color bg = cell.getBackground();
        Composite composite = new Composite(cell, this.getStyle());
        composite.setBackground(bg);
        composite.setLayout((Layout)new FillLayout());
        this.text = new Text(composite, 4);
        this.text.setBackground(bg);
        this.text.setFont(cell.getFont());
        this.text.addModifyListener((ModifyListener)this);
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    ExpressionDialogCellEditor.this.applyEditorValueAndDeactivate();
                }
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (ExpressionDialogCellEditor.this.btnPopup != null && !ExpressionDialogCellEditor.this.btnPopup.isFocusControl() && Display.getCurrent().getCursorControl() != ExpressionDialogCellEditor.this.btnPopup) {
                    ExpressionDialogCellEditor.this.applyEditorValueAndDeactivate();
                }
            }
        });
        return composite;
    }

    protected Button createButton(Composite parent) {
        this.btnPopup = super.createButton(parent);
        return this.btnPopup;
    }

    void applyEditorValueAndDeactivate() {
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected Object doGetValue() {
        return this.text.getText();
    }

    protected void doSetFocus() {
        this.text.setFocus();
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        return this.openDialogBox(cellEditorWindow, (String)this.getValue());
    }

    String openDialogBox(Control cellEditorWindow, String oldValue) {
        String newValue;
        ExpressionBuilder dialog = new ExpressionBuilder(cellEditorWindow.getShell(), oldValue);
        dialog.setExpressionProvier((IExpressionProvider)new ExpressionProvider(this.itemHandle));
        if (dialog.open() == 0 && !(newValue = dialog.getResult()).equals(oldValue)) {
            return newValue;
        }
        this.setFocus();
        return null;
    }

    public void setItemHandle(DesignElementHandle handle) {
        this.itemHandle = handle;
    }

    public void modifyText(ModifyEvent e) {
    }

    protected void updateContents(Object value) {
        if (this.text == null) {
            return;
        }
        String displayText = "";
        if (value != null) {
            displayText = value.toString();
        }
        this.text.setText(displayText);
    }
}

