/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LeaderLineStyle implements Enumerator
{
    FIXED_LENGTH_LITERAL(0, "FixedLength", "Fixed_Length"),
    STRETCH_TO_SIDE_LITERAL(1, "StretchToSide", "Stretch_To_Side");

    public static final int FIXED_LENGTH = 0;
    public static final int STRETCH_TO_SIDE = 1;
    private static final LeaderLineStyle[] VALUES_ARRAY;
    public static final List<LeaderLineStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LeaderLineStyle[]{FIXED_LENGTH_LITERAL, STRETCH_TO_SIDE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LeaderLineStyle get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LeaderLineStyle result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LeaderLineStyle getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LeaderLineStyle result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LeaderLineStyle get(int value) {
        switch (value) {
            case 0: {
                return FIXED_LENGTH_LITERAL;
            }
            case 1: {
                return STRETCH_TO_SIDE_LITERAL;
            }
        }
        return null;
    }

    private LeaderLineStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

