/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.util;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.draw3d.RenderContext;
import org.eclipse.draw3d.Renderable;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Math3DCache;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.graphics3d.Graphics3D;

public class DebugPrimitives
implements Renderable {
    private static DebugPrimitives INSTANCE;
    private Map<Object, Vector3f[]> m_lines = new HashMap<Object, Vector3f[]>();
    private Map<Object, Vector3f> m_points = new HashMap<Object, Vector3f>();
    private Map<Object, Vector3f[]> m_rays = new HashMap<Object, Vector3f[]>();
    private Map<Object, Vector3f[]> m_segments = new HashMap<Object, Vector3f[]>();
    private static Logger log;
    private boolean m_warning = true;

    static {
        log = Logger.getLogger(DebugPrimitives.class.getName());
    }

    public static DebugPrimitives getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DebugPrimitives();
        }
        return INSTANCE;
    }

    public static boolean hasInstance() {
        return INSTANCE != null;
    }

    private DebugPrimitives() {
    }

    public void addLine(Object i_key, IVector3f i_p1, IVector3f i_p2) {
        if (i_key == null) {
            throw new NullPointerException("i_key must not be null");
        }
        if (i_p1 == null) {
            throw new NullPointerException("i_p1 must not be null");
        }
        if (i_p2 == null) {
            throw new NullPointerException("i_p2 must not be null");
        }
        Vector3f[] line = this.m_lines.get(i_key);
        if (line == null) {
            line = new Vector3f[]{new Vector3fImpl(), new Vector3fImpl()};
            this.m_lines.put(i_key, line);
        }
        line[0].set(i_p1);
        line[1].set(i_p2);
    }

    public void addPoint(Object i_key, IVector3f i_p) {
        if (i_key == null) {
            throw new NullPointerException("i_key must not be null");
        }
        if (i_p == null) {
            throw new NullPointerException("i_p must not be null");
        }
        Vector3f point = this.m_points.get(i_key);
        if (point == null) {
            point = new Vector3fImpl();
            this.m_points.put(i_key, point);
        }
        point.set(i_p);
    }

    public void addRay(Object i_key, IVector3f i_rayOrigin, IVector3f i_rayDirection) {
        if (i_key == null) {
            throw new NullPointerException("i_key must not be null");
        }
        if (i_rayOrigin == null) {
            throw new NullPointerException("i_rayOrigin must not be null");
        }
        if (i_rayDirection == null) {
            throw new NullPointerException("i_rayDirection must not be null");
        }
        Vector3f[] ray = this.m_rays.get(i_key);
        if (ray == null) {
            ray = new Vector3f[]{new Vector3fImpl(), new Vector3fImpl()};
            this.m_rays.put(i_key, ray);
        }
        ray[0].set(i_rayOrigin);
        ray[1].set(i_rayDirection);
    }

    public void addSegment(Object i_key, IVector3f i_p1, IVector3f i_p2) {
        if (i_key == null) {
            throw new NullPointerException("i_key must not be null");
        }
        if (i_p1 == null) {
            throw new NullPointerException("i_p1 must not be null");
        }
        if (i_p2 == null) {
            throw new NullPointerException("i_p2 must not be null");
        }
        Vector3f[] segment = this.m_segments.get(i_key);
        if (segment == null) {
            segment = new Vector3f[]{new Vector3fImpl(), new Vector3fImpl()};
            this.m_segments.put(i_key, segment);
        }
        segment[0].set(i_p1);
        segment[1].set(i_p2);
    }

    public void clear() {
        this.m_lines.clear();
        this.m_rays.clear();
        this.m_segments.clear();
        this.m_points.clear();
    }

    private float getFactor(IVector3f i_v) {
        float fx = 10000.0f / i_v.getX();
        float fy = 10000.0f / i_v.getY();
        float fz = 10000.0f / i_v.getZ();
        return Math.min(fx, Math.min(fy, fz));
    }

    public void prerender(RenderContext i_renderContext) {
    }

    public void render(RenderContext i_renderContext) {
        if (this.m_warning) {
            log.warning("You are using debug primitives. Don't forget to remove them.");
            this.m_warning = false;
        }
        this.renderLines(i_renderContext);
        this.renderRays(i_renderContext);
        this.renderSegments(i_renderContext);
        this.renderPoints(i_renderContext);
    }

    private void renderLines(RenderContext i_renderContext) {
        if (this.m_lines.isEmpty()) {
            return;
        }
        Vector3f dir = Math3DCache.getVector3f();
        Vector3f start = Math3DCache.getVector3f();
        Vector3f end = Math3DCache.getVector3f();
        try {
            Graphics3D g3D = i_renderContext.getGraphics3D();
            g3D.glLineWidth(1.0f);
            g3D.glColor4f(1.0f, 0.0f, 0.0f, 0.5f);
            g3D.glBegin(1);
            for (IVector3f[] iVector3fArray : this.m_lines.values()) {
                IVector3f p1 = iVector3fArray[0];
                IVector3f p2 = iVector3fArray[1];
                Math3D.sub((IVector3f)p2, (IVector3f)p1, (Vector3f)dir);
                float f = this.getFactor((IVector3f)dir);
                Math3D.scale((float)f, (IVector3f)dir, (Vector3f)start);
                Math3D.add((IVector3f)p1, (IVector3f)start, (Vector3f)start);
                Math3D.scale((float)(-f), (IVector3f)dir, (Vector3f)end);
                Math3D.add((IVector3f)p1, (IVector3f)end, (Vector3f)end);
                g3D.glVertex3f(start.getX(), start.getY(), start.getZ());
                g3D.glVertex3f(end.getX(), end.getY(), end.getZ());
            }
            g3D.glEnd();
        }
        catch (Throwable throwable) {
            Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{dir, start, end});
            throw throwable;
        }
        Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{dir, start, end});
    }

    private void renderPoints(RenderContext i_renderContext) {
        if (this.m_points.isEmpty()) {
            return;
        }
        Graphics3D g3D = i_renderContext.getGraphics3D();
        g3D.glPointSize(5.0f);
        g3D.glColor4f(0.0f, 1.0f, 1.0f, 0.5f);
        g3D.glBegin(0);
        for (IVector3f iVector3f : this.m_points.values()) {
            g3D.glVertex3f(iVector3f.getX(), iVector3f.getY(), iVector3f.getZ());
        }
        g3D.glEnd();
    }

    private void renderRays(RenderContext i_renderContext) {
        if (this.m_rays.isEmpty()) {
            return;
        }
        Vector3f end = Math3DCache.getVector3f();
        try {
            Graphics3D g3D = i_renderContext.getGraphics3D();
            g3D.glLineWidth(1.0f);
            g3D.glColor4f(0.0f, 1.0f, 0.0f, 0.5f);
            g3D.glBegin(1);
            for (Vector3f[] ray : this.m_rays.values()) {
                Vector3f start = ray[0];
                Vector3f direction = ray[1];
                float f = this.getFactor((IVector3f)direction);
                Math3D.scale((float)f, (IVector3f)direction, (Vector3f)end);
                Math3D.add((IVector3f)start, (IVector3f)end, (Vector3f)end);
                g3D.glVertex3f(start.getX(), start.getY(), start.getZ());
                g3D.glVertex3f(end.getX(), end.getY(), end.getZ());
            }
            g3D.glEnd();
        }
        catch (Throwable throwable) {
            Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{end});
            throw throwable;
        }
        Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{end});
    }

    private void renderSegments(RenderContext i_renderContext) {
        if (this.m_segments.isEmpty()) {
            return;
        }
        Vector3f end = Math3DCache.getVector3f();
        try {
            Graphics3D g3D = i_renderContext.getGraphics3D();
            g3D.glLineWidth(1.0f);
            g3D.glColor4f(0.0f, 0.0f, 1.0f, 0.5f);
            g3D.glBegin(1);
            for (IVector3f[] iVector3fArray : this.m_segments.values()) {
                IVector3f p1 = iVector3fArray[0];
                IVector3f p2 = iVector3fArray[1];
                g3D.glVertex3f(p1.getX(), p1.getY(), p1.getZ());
                g3D.glVertex3f(p2.getX(), p2.getY(), p2.getZ());
            }
            g3D.glEnd();
        }
        catch (Throwable throwable) {
            Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{end});
            throw throwable;
        }
        Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{end});
    }

    public void collectRenderFragments(RenderContext i_renderContext) {
    }
}

