/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.util.converter;

import org.eclipse.draw3d.util.converter.ConversionPolicy;
import org.eclipse.draw3d.util.converter.ConversionPolicySpecs;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;

public class ImageToLuminanceAlphaPolicy
extends ConversionPolicy {
    protected int[] getSupportedDataTypes(ConversionPolicySpecs.ConversionDirection i_direction) {
        if (i_direction != ConversionPolicySpecs.ConversionDirection.IMAGE_TO_BUFFER) {
            throw new IllegalArgumentException("unsupported conversion direction: " + (Object)((Object)i_direction));
        }
        return new int[]{5121};
    }

    protected ConversionPolicySpecs.ConversionDirection[] getSupportedDirections() {
        return new ConversionPolicySpecs.ConversionDirection[]{ConversionPolicySpecs.ConversionDirection.IMAGE_TO_BUFFER};
    }

    protected int[] getSupportedImageDepths(ConversionPolicySpecs.ConversionDirection i_direction) {
        if (i_direction != ConversionPolicySpecs.ConversionDirection.IMAGE_TO_BUFFER) {
            throw new IllegalArgumentException("unsupported conversion direction: " + (Object)((Object)i_direction));
        }
        return new int[]{24, 32};
    }

    protected int[] getSupportedPixelFormats(ConversionPolicySpecs.ConversionDirection i_direction) {
        if (i_direction != ConversionPolicySpecs.ConversionDirection.IMAGE_TO_BUFFER) {
            throw new IllegalArgumentException("unsupported conversion direction: " + (Object)((Object)i_direction));
        }
        return new int[]{6410};
    }

    protected byte[] toBytes(int i_x, int i_y, ImageData i_imageData) {
        int pixel = i_imageData.getPixel(i_x, i_y);
        RGB rgb = i_imageData.palette.getRGB(pixel);
        byte l = (byte)Math.round((double)(rgb.red + rgb.green + rgb.blue) / 3.0);
        byte a = (byte)(255 - l);
        return new byte[]{l, a};
    }
}

