/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.util.converter;

import java.nio.ByteBuffer;

public class ColorBufferInfo {
    private int m_alignment;
    private int m_bytesPerAlignedLine;
    private int m_bytesPerLine;
    private int m_bytesPerPixel;
    private int m_dataType;
    private int m_height;
    private int m_pixelFormat;
    private int m_size;
    private int m_width;

    public ColorBufferInfo(int i_width, int i_height, int i_pixelFormat, int i_dataType, int i_alignment) {
        if (i_width <= 0 || i_height <= 0) {
            throw new IllegalArgumentException("width and height must be positive");
        }
        if (i_alignment <= 0) {
            throw new IllegalArgumentException("alignment must be positive");
        }
        this.m_width = i_width;
        this.m_height = i_height;
        this.m_pixelFormat = i_pixelFormat;
        this.m_dataType = i_dataType;
        this.m_alignment = i_alignment;
        this.m_bytesPerPixel = this.getColorBpp(this.m_pixelFormat, this.m_dataType);
        this.m_bytesPerLine = this.m_width * this.m_bytesPerPixel;
        this.m_bytesPerAlignedLine = ((this.m_bytesPerLine - 1) / this.m_alignment + 1) * this.m_alignment;
        this.m_size = this.m_bytesPerAlignedLine * this.m_height;
    }

    public int getAlignment() {
        return this.m_alignment;
    }

    public int getBytesPerAlignedLine() {
        return this.m_bytesPerAlignedLine;
    }

    public int getBytesPerLine() {
        return this.m_bytesPerLine;
    }

    public int getColorBpp(int i_pixelFormat, int i_dataType) {
        int bpp;
        switch (i_pixelFormat) {
            case 6400: 
            case 6401: 
            case 6403: 
            case 6404: 
            case 6405: 
            case 6406: 
            case 6409: {
                bpp = 1;
                break;
            }
            case 6402: 
            case 6410: {
                bpp = 2;
                break;
            }
            case 6407: 
            case 32992: {
                bpp = 3;
                break;
            }
            case 6408: 
            case 32993: {
                bpp = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("unuspported pixel format: " + i_pixelFormat);
            }
        }
        switch (i_dataType) {
            case 32818: 
            case 33634: {
                bpp = 1;
                break;
            }
            case 32819: 
            case 32820: 
            case 33635: 
            case 33636: 
            case 33637: 
            case 33638: {
                bpp = 2;
                break;
            }
            case 32821: 
            case 32822: 
            case 33639: 
            case 33640: {
                bpp = 4;
                break;
            }
            case 5120: 
            case 5121: {
                bpp *= 1;
                break;
            }
            case 5122: 
            case 5123: {
                bpp *= 2;
                break;
            }
            case 5124: 
            case 5125: 
            case 5126: {
                bpp *= 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("unuspported data type: " + i_dataType);
            }
        }
        return bpp;
    }

    public int getDataType() {
        return this.m_dataType;
    }

    public int getHeight() {
        return this.m_height;
    }

    public int getPixelFormat() {
        return this.m_pixelFormat;
    }

    public int getRemainingBytes(ByteBuffer i_buffer) {
        int pos = i_buffer.position();
        int linePos = pos % this.m_bytesPerAlignedLine;
        return this.m_bytesPerLine - linePos;
    }

    public int getSize() {
        return this.m_size;
    }

    public int getWidth() {
        return this.m_width;
    }

    public void putAlignedBytes(byte[] i_bytes, ByteBuffer io_buffer) {
        int rem = this.getRemainingBytes(io_buffer);
        int len = Math.min(rem, i_bytes.length);
        io_buffer.put(i_bytes, 0, len);
        if (i_bytes.length > rem) {
            int pos = io_buffer.position();
            int skip = pos & this.m_alignment;
            io_buffer.position(pos + skip);
            int index = len;
            len = i_bytes.length - index + 1;
            io_buffer.put(i_bytes, index, len);
        }
    }
}

