/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics.optimizer.primitive;

import org.eclipse.draw3d.geometry.IMatrix3f;
import org.eclipse.draw3d.graphics.GraphicsState;
import org.eclipse.draw3d.graphics.optimizer.primitive.AbstractVertexPrimitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.GradientRenderRule;
import org.eclipse.draw3d.graphics.optimizer.primitive.OutlineRenderRule;
import org.eclipse.draw3d.graphics.optimizer.primitive.RenderRule;
import org.eclipse.draw3d.graphics.optimizer.primitive.SolidRenderRule;

public class QuadPrimitive
extends AbstractVertexPrimitive {
    public static QuadPrimitive createGradientQuad(GraphicsState i_state, int i_x, int i_y, int i_width, int i_height, boolean i_vertical) {
        return new QuadPrimitive((IMatrix3f)i_state.getTransformation(), (RenderRule)new GradientRenderRule(i_state), QuadPrimitive.getVertices(i_x, i_y, i_width, i_height, i_vertical));
    }

    public static QuadPrimitive createOutlineQuad(GraphicsState i_state, int i_x, int i_y, int i_width, int i_height) {
        return new QuadPrimitive((IMatrix3f)i_state.getTransformation(), (RenderRule)new OutlineRenderRule(i_state), QuadPrimitive.getVertices(i_x, i_y, i_width, i_height, false));
    }

    public static QuadPrimitive createSolidQuad(GraphicsState i_state, int i_x, int i_y, int i_width, int i_height) {
        return new QuadPrimitive((IMatrix3f)i_state.getTransformation(), (RenderRule)new SolidRenderRule(i_state), QuadPrimitive.getVertices(i_x, i_y, i_width, i_height, false));
    }

    protected static float[] getVertices(int i_x, int i_y, int i_w, int i_h, boolean i_shift) {
        if (i_shift) {
            return new float[]{i_x + i_w, i_y, i_x, i_y, i_x, i_y + i_h, i_x + i_w, i_y + i_h};
        }
        return new float[]{i_x, i_y, i_x, i_y + i_h, i_x + i_w, i_y + i_h, i_x + i_w, i_y};
    }

    protected QuadPrimitive(IMatrix3f i_transformation, RenderRule i_renderRule, float[] i_vertices) {
        super(i_transformation, i_renderRule, i_vertices);
        if (i_vertices.length != 8) {
            throw new IllegalArgumentException("a quad must contain exactly four vertices");
        }
    }
}

