/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf3d;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.amp.agf.gef.ScapeEditPart;
import org.eclipse.amp.agf3d.AgentEdit3DPart;
import org.eclipse.amp.agf3d.GEF3DViewPart;
import org.eclipse.amp.agf3d.ScapeEditRoot3DPart;
import org.eclipse.amp.axf.core.ICompositionProvider;
import org.eclipse.amp.axf.space.ILocation2D;
import org.eclipse.amp.axf.space.ILocation3D;
import org.eclipse.amp.axf.space.ILocationProvider;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw3d.Figure3D;
import org.eclipse.draw3d.FigureSurface;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.ISurface;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3DVector3f;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;

public class ScapeEdit3DPart
extends ScapeEditPart {
    Map<Object, IVector3f> startPoints = new HashMap<Object, IVector3f>();
    Map<Object, Vector3f> addPoints = new HashMap<Object, Vector3f>();
    Map<Object, Vector3f> lastPoints = new HashMap<Object, Vector3f>();
    private List<EditPart> newParts = new ArrayList<EditPart>();

    public ScapeEdit3DPart(ICompositionProvider memberProvider, ILocationProvider locationProvider, IFilter filter) {
        super(memberProvider, locationProvider, filter);
    }

    protected IFigure createFigure() {
        Figure3D figure = new Figure3D(){
            private ISurface m_surface = new FigureSurface((IFigure3D)this);

            public ISurface getSurface() {
                return this.m_surface;
            }

            public void invalidateParaxialBoundsTree() {
                super.invalidateParaxialBounds();
            }
        };
        figure.setLayoutManager((LayoutManager)new Scape3DLayoutManager());
        figure.setBounds(this.getRootScapeEditPart().getFigure().getBounds());
        return figure;
    }

    protected void addChild(EditPart child, int index) {
        super.addChild(child, index);
        this.newParts.add(child);
    }

    protected synchronized void calculateConstraints(GraphicalEditPart editPart) {
        Object agent = editPart.getModel();
        ILocation2D location = (ILocation2D)this.getLocationProvider().getLocation(agent);
        IFigure3D agentFigure = (IFigure3D)editPart.getFigure();
        Vector3fImpl endPoint = null;
        if (location != null && editPart instanceof AgentEdit3DPart) {
            float x = (float)(20.0 * location.getXDouble());
            float y = (float)(20.0 * location.getYDouble());
            float z = 0.0f;
            if (location instanceof ILocation3D) {
                z = (float)(20.0 * location.getYDouble());
            }
            endPoint = new Vector3fImpl(x, y, z);
            endPoint = Math3DVector3f.add((IVector3f)endPoint, (IVector3f)((AgentEdit3DPart)editPart).getRelativeLocation3D(), (Vector3f)endPoint);
            ScapeEditRoot3DPart root = (ScapeEditRoot3DPart)this.getRootScapeEditPart();
            Vector3f priorPeriodLocation = this.lastPoints.get(agent);
            if (root.getAnimationStepCount() > 1) {
                if (priorPeriodLocation != null) {
                    Vector3fImpl difference = new Vector3fImpl();
                    difference = Math3DVector3f.sub((IVector3f)endPoint, (IVector3f)priorPeriodLocation, (Vector3f)difference);
                    difference = Math3DVector3f.abs((IVector3f)difference, (Vector3f)difference);
                    Rectangle bounds = this.getFigure().getBounds();
                    if (root.getAnimationStepCount() > 1 && this.getRootScapeEditPart().getModel() != null && difference.getX() < (float)bounds.width * 0.7f && difference.getY() < (float)bounds.height * 0.7f) {
                        Vector3f addPoint;
                        if (root.getAnimationStep() == 0) {
                            IVector3f startPoint = agentFigure.getPosition3D().getLocation3D();
                            this.startPoints.put(agent, startPoint);
                            addPoint = new Vector3fImpl();
                            GEF3DViewPart.calculateDelta(startPoint, (IVector3f)endPoint, addPoint, root.getAnimationStepCount());
                            this.addPoints.put(agent, addPoint);
                            this.lastPoints.put(agent, (Vector3f)new Vector3fImpl(startPoint.getX(), startPoint.getY(), startPoint.getZ()));
                        } else {
                            IVector3f startPoint = this.startPoints.get(agent);
                            addPoint = this.addPoints.get(agent);
                        }
                        Vector3fImpl intermediatePoint = new Vector3fImpl();
                        IVector3f currentPoint = (IVector3f)this.lastPoints.get(agent);
                        Math3DVector3f.add((IVector3f)currentPoint, (IVector3f)addPoint, (Vector3f)intermediatePoint);
                        this.setLayoutConstraint((EditPart)editPart, editPart.getFigure(), intermediatePoint);
                        this.lastPoints.put(agent, (Vector3f)intermediatePoint);
                    } else {
                        this.setLayoutConstraint((EditPart)editPart, editPart.getFigure(), endPoint);
                    }
                } else if (root.getAnimationStep() == 0) {
                    this.setLayoutConstraint((EditPart)editPart, editPart.getFigure(), endPoint);
                } else if (root.getAnimationStep() >= root.getAnimationStepCount() - 1) {
                    this.lastPoints.put(agent, (Vector3f)endPoint);
                } else {
                    float f = (float)root.getAnimationStep() / (float)root.getAnimationStepCount();
                    int scaledColor = (int)(f * 256.0f) - 1;
                    IFigure3D figure3D = (IFigure3D)this.figure;
                    if (figure3D != null) {
                        figure3D.setForegroundColor(new Color((Device)this.getViewer().getControl().getDisplay(), scaledColor, scaledColor, 255));
                        this.figure.repaint();
                    }
                }
            } else {
                this.setLayoutConstraint((EditPart)editPart, editPart.getFigure(), endPoint);
            }
        }
    }

    class Scape3DLayoutManager
    extends XYLayout {
        Scape3DLayoutManager() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            return null;
        }

        public void layout(IFigure parent) {
            if (ScapeEdit3DPart.this.getMemberProvider().isMutable(ScapeEdit3DPart.this.getModel())) {
                for (IFigure3D f : parent.getChildren()) {
                    IVector3f location = (IVector3f)this.getConstraint((IFigure)f);
                    if (location == null) continue;
                    f.getPosition3D().setLocation3D(location);
                }
            }
        }
    }
}

