/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SImplementationMode implements Enumerator
{
    GENERATE_LITERAL(1000, "Generate", "GENERATE"),
    GENERATE_PROTECTED_LITERAL(1500, "GenerateProtected", "GENERATE_PROTECTED"),
    GENERATE_EMPTY_LITERAL(1600, "GenerateEmpty", "GENERATE_EMPTY"),
    LOAD_LITERAL(2000, "Load", "LOAD"),
    EXTERNAL_LITERAL(3000, "External", "EXTERNAL");

    public static final int GENERATE = 1000;
    public static final int GENERATE_PROTECTED = 1500;
    public static final int GENERATE_EMPTY = 1600;
    public static final int LOAD = 2000;
    public static final int EXTERNAL = 3000;
    private static final SImplementationMode[] VALUES_ARRAY;
    public static final List<SImplementationMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SImplementationMode[]{GENERATE_LITERAL, GENERATE_PROTECTED_LITERAL, GENERATE_EMPTY_LITERAL, LOAD_LITERAL, EXTERNAL_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SImplementationMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SImplementationMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SImplementationMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SImplementationMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SImplementationMode get(int value) {
        switch (value) {
            case 1000: {
                return GENERATE_LITERAL;
            }
            case 1500: {
                return GENERATE_PROTECTED_LITERAL;
            }
            case 1600: {
                return GENERATE_EMPTY_LITERAL;
            }
            case 2000: {
                return LOAD_LITERAL;
            }
            case 3000: {
                return EXTERNAL_LITERAL;
            }
        }
        return null;
    }

    private SImplementationMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

