/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.draw3d.graphics3d.Graphics3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayListManager {
    private static final Logger log = Logger.getLogger(DisplayListManager.class.getName());
    private static final int RANGE = 10;
    private boolean m_active = false;
    private List<Integer> m_baseIds = new ArrayList<Integer>();
    private LinkedList<LinkedList<Integer>> m_creationStack = new LinkedList();
    private Map<Object, DisplayList> m_displayLists = new HashMap<Object, DisplayList>();
    private final boolean m_disposed = false;
    private Queue<Integer> m_freeIds = new LinkedList<Integer>();
    private Graphics3D m_graphics3D;
    private int m_index = 10;

    public DisplayListManager(Graphics3D i_graphics3D) {
        if (i_graphics3D == null) {
            throw new NullPointerException("i_graphics3D must not be null");
        }
        this.m_graphics3D = i_graphics3D;
    }

    public void clear() {
        for (int baseId : this.m_baseIds) {
            this.m_graphics3D.glDeleteLists(baseId, 10);
        }
        this.m_index = 10;
        this.m_baseIds.clear();
        this.m_displayLists.clear();
        this.m_freeIds.clear();
        this.m_creationStack.clear();
        this.m_active = false;
    }

    public void createDisplayList(Object i_key, Runnable i_runnable) {
        if (i_key == null) {
            throw new NullPointerException("i_key must not be null");
        }
        if (i_runnable == null) {
            throw new NullPointerException("i_runnable must not be null");
        }
        if (this.m_active) {
            throw new IllegalStateException("cannot create a display list while another list is being created");
        }
        this.doCreateDisplayList(i_key, i_runnable);
    }

    public void createDisplayLists(Map<Object, Runnable> i_requests) {
        if (i_requests == null) {
            throw new NullPointerException("i_requests must not be null");
        }
        if (this.m_active) {
            throw new IllegalStateException("cannot create a display list while another list is being created");
        }
        for (Map.Entry<Object, Runnable> entry : i_requests.entrySet()) {
            this.doCreateDisplayList(entry.getKey(), entry.getValue());
        }
    }

    public void dispose() {
        this.clear();
        this.m_baseIds = null;
        this.m_displayLists = null;
        this.m_creationStack = null;
    }

    private DisplayList doCreateDisplayList(Object i_key, Runnable i_runnable) {
        if (this.m_displayLists.containsKey(i_key)) {
            this.deleteDisplayLists(i_key);
        }
        Integer id = this.getNewId();
        LinkedList<Integer> subListIds = new LinkedList<Integer>();
        subListIds.add(id);
        this.m_creationStack.addLast(subListIds);
        this.m_active = true;
        this.m_graphics3D.glNewList(id, 4864);
        i_runnable.run();
        this.m_graphics3D.glEndList();
        this.m_active = false;
        if (subListIds.size() > 1) {
            id = this.getNewId();
            this.m_graphics3D.glNewList(id, 4864);
            for (Integer subListId : subListIds) {
                this.m_graphics3D.glCallList(subListId);
            }
            this.m_graphics3D.glEndList();
        }
        DisplayList list = new DisplayList(id, subListIds);
        this.m_displayLists.put(i_key, list);
        this.m_creationStack.removeLast();
        return list;
    }

    private void deleteDisplayList(Integer id) {
        this.m_graphics3D.glDeleteLists(id, 1);
        this.m_freeIds.offer(id);
    }

    public void deleteDisplayLists(Object ... i_keys) {
        Object[] objectArray = i_keys;
        int n = i_keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            DisplayList list = this.m_displayLists.get(key);
            if (list == null) {
                throw new IllegalArgumentException("list with key '" + Arrays.toString(i_keys) + "' does not exist");
            }
            this.deleteDisplayList(list.getId());
            int[] subIds = list.getSubIds();
            if (subIds != null) {
                int i = 0;
                while (i < subIds.length) {
                    this.deleteDisplayList(subIds[i]);
                    ++i;
                }
            }
            this.m_displayLists.remove(key);
            ++n2;
        }
    }

    public void executeDisplayList(Object i_key) {
        if (i_key == null) {
            throw new NullPointerException("i_key must not be null");
        }
        DisplayList list = this.m_displayLists.get(i_key);
        if (list == null) {
            throw new IllegalArgumentException("unknown display list: " + i_key);
        }
        this.m_graphics3D.glCallList(list.getId());
    }

    private int getNewId() {
        int baseId;
        if (!this.m_freeIds.isEmpty()) {
            return this.m_freeIds.poll();
        }
        if (this.m_index == 10) {
            baseId = this.m_graphics3D.glGenLists(10);
            this.m_baseIds.add(baseId);
            this.m_index = 0;
        }
        baseId = this.m_baseIds.get(this.m_baseIds.size() - 1);
        return baseId + this.m_index++;
    }

    public void interruptDisplayList() {
        if (!this.m_creationStack.isEmpty()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("interrupting creation of display list with id " + this.m_creationStack.getLast().getLast());
            }
            this.m_graphics3D.glEndList();
            this.m_active = false;
        }
    }

    public boolean isDisplayList(Object ... i_keys) {
        if (i_keys != null && i_keys.length > 0) {
            Object[] objectArray = i_keys;
            int n = i_keys.length;
            int n2 = 0;
            while (n2 < n) {
                Object key = objectArray[n2];
                if (!this.m_displayLists.containsKey(key)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public void resumeDisplayList() {
        if (!this.m_creationStack.isEmpty()) {
            Integer id = this.getNewId();
            this.m_creationStack.getLast().add(id);
            this.m_graphics3D.glNewList(id, 4864);
            this.m_active = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DisplayList {
        private int m_id;
        private int[] m_subIds;

        public DisplayList(int i_id, Collection<Integer> i_subIds) {
            this.m_id = i_id;
            if (i_subIds != null && !i_subIds.isEmpty()) {
                this.m_subIds = new int[i_subIds.size()];
                int i = 0;
                for (Integer subId : i_subIds) {
                    this.m_subIds[i++] = subId;
                }
            }
        }

        public int getId() {
            return this.m_id;
        }

        public int[] getSubIds() {
            return this.m_subIds;
        }
    }
}

