/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry;

import java.io.Serializable;
import java.nio.FloatBuffer;
import java.util.Arrays;
import org.eclipse.draw3d.geometry.IMatrix4f;
import org.eclipse.draw3d.geometry.Matrix4f;

public class Matrix4fImpl
implements Matrix4f,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public float a11;
    public float a12;
    public float a13;
    public float a14;
    public float a21;
    public float a22;
    public float a23;
    public float a24;
    public float a31;
    public float a32;
    public float a33;
    public float a34;
    public float a41;
    public float a42;
    public float a43;
    public float a44;

    static Matrix4fImpl cast(IMatrix4f i_sourceMatrix4f) {
        if (i_sourceMatrix4f instanceof Matrix4fImpl) {
            return (Matrix4fImpl)i_sourceMatrix4f;
        }
        return new Matrix4fImpl(i_sourceMatrix4f);
    }

    public Matrix4fImpl() {
        this.a11 = 1.0f;
        this.a22 = 1.0f;
        this.a33 = 1.0f;
        this.a44 = 1.0f;
    }

    public Matrix4fImpl(float[] i_arrayOfFloat, boolean i_bColumnMajor) {
        this(i_arrayOfFloat, i_bColumnMajor, 0);
    }

    public Matrix4fImpl(float[] i_arrayOfFloat, boolean i_bColumnMajor, int i_iOffset) {
        if (i_bColumnMajor) {
            this.a11 = i_arrayOfFloat[i_iOffset++];
            this.a21 = i_arrayOfFloat[i_iOffset++];
            this.a31 = i_arrayOfFloat[i_iOffset++];
            this.a41 = i_arrayOfFloat[i_iOffset++];
            this.a12 = i_arrayOfFloat[i_iOffset++];
            this.a22 = i_arrayOfFloat[i_iOffset++];
            this.a32 = i_arrayOfFloat[i_iOffset++];
            this.a42 = i_arrayOfFloat[i_iOffset++];
            this.a13 = i_arrayOfFloat[i_iOffset++];
            this.a23 = i_arrayOfFloat[i_iOffset++];
            this.a33 = i_arrayOfFloat[i_iOffset++];
            this.a43 = i_arrayOfFloat[i_iOffset++];
            this.a14 = i_arrayOfFloat[i_iOffset++];
            this.a24 = i_arrayOfFloat[i_iOffset++];
            this.a34 = i_arrayOfFloat[i_iOffset++];
            this.a44 = i_arrayOfFloat[i_iOffset];
        } else {
            this.a11 = i_arrayOfFloat[i_iOffset++];
            this.a12 = i_arrayOfFloat[i_iOffset++];
            this.a13 = i_arrayOfFloat[i_iOffset++];
            this.a14 = i_arrayOfFloat[i_iOffset++];
            this.a21 = i_arrayOfFloat[i_iOffset++];
            this.a22 = i_arrayOfFloat[i_iOffset++];
            this.a23 = i_arrayOfFloat[i_iOffset++];
            this.a24 = i_arrayOfFloat[i_iOffset++];
            this.a31 = i_arrayOfFloat[i_iOffset++];
            this.a32 = i_arrayOfFloat[i_iOffset++];
            this.a33 = i_arrayOfFloat[i_iOffset++];
            this.a34 = i_arrayOfFloat[i_iOffset++];
            this.a41 = i_arrayOfFloat[i_iOffset++];
            this.a42 = i_arrayOfFloat[i_iOffset++];
            this.a43 = i_arrayOfFloat[i_iOffset++];
            this.a44 = i_arrayOfFloat[i_iOffset];
        }
    }

    public Matrix4fImpl(FloatBuffer i_buffer, boolean i_bColumnMajor) {
        if (!i_bColumnMajor) {
            this.setRowMajor(i_buffer);
        } else {
            this.setColumnMajor(i_buffer);
        }
    }

    public Matrix4fImpl(IMatrix4f i_sourceMatrix4f) {
        if (i_sourceMatrix4f == null) {
            throw new NullPointerException("i_sourceMatrix4f must not be null");
        }
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                this.set(i, j, i_sourceMatrix4f.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    public Matrix4fImpl(float a11, float a12, float a13, float a14, float a21, float a22, float a23, float a24, float a31, float a32, float a33, float a34, float a41, float a42, float a43, float a44) {
        this.a11 = a11;
        this.a12 = a12;
        this.a13 = a13;
        this.a14 = a14;
        this.a21 = a21;
        this.a22 = a22;
        this.a23 = a23;
        this.a24 = a24;
        this.a31 = a31;
        this.a32 = a32;
        this.a33 = a33;
        this.a34 = a34;
        this.a41 = a41;
        this.a42 = a42;
        this.a43 = a43;
        this.a44 = a44;
    }

    public Object clone() throws CloneNotSupportedException {
        return new Matrix4fImpl(this);
    }

    public boolean equals(IMatrix4f i_anotherMatrix4f) {
        if (this == i_anotherMatrix4f) {
            return true;
        }
        if (i_anotherMatrix4f == null) {
            return false;
        }
        Matrix4fImpl sm = Matrix4fImpl.cast(i_anotherMatrix4f);
        return this.a11 == sm.a11 && this.a12 == sm.a12 && this.a13 == sm.a13 && this.a14 == sm.a14 && this.a21 == sm.a21 && this.a22 == sm.a22 && this.a23 == sm.a23 && this.a24 == sm.a24 && this.a31 == sm.a31 && this.a32 == sm.a32 && this.a33 == sm.a33 && this.a34 == sm.a34 && this.a41 == sm.a41 && this.a42 == sm.a42 && this.a43 == sm.a43 && this.a44 == sm.a44;
    }

    public int hashCode() {
        float[] af = new float[16];
        this.toArrayRowMajor(af);
        return Arrays.hashCode(af);
    }

    public void set(IMatrix4f i_sourceMatrix4f) {
        Matrix4fImpl src = Matrix4fImpl.cast(i_sourceMatrix4f);
        this.a11 = src.a11;
        this.a12 = src.a12;
        this.a13 = src.a13;
        this.a14 = src.a14;
        this.a21 = src.a21;
        this.a22 = src.a22;
        this.a23 = src.a23;
        this.a24 = src.a24;
        this.a31 = src.a31;
        this.a32 = src.a32;
        this.a33 = src.a33;
        this.a34 = src.a34;
        this.a41 = src.a41;
        this.a42 = src.a42;
        this.a43 = src.a43;
        this.a44 = src.a44;
    }

    public float get(int i_row, int i_column) {
        if (i_row < 0 || i_row >= 4) {
            throw new IllegalArgumentException("row index out of bounds: " + i_row);
        }
        if (i_column < 0 || i_column >= 4) {
            throw new IllegalArgumentException("column index out of bounds: " + i_column);
        }
        if (i_row == 0) {
            if (i_column == 0) {
                return this.a11;
            }
            if (i_column == 1) {
                return this.a12;
            }
            if (i_column == 2) {
                return this.a13;
            }
            return this.a14;
        }
        if (i_row == 1) {
            if (i_column == 0) {
                return this.a21;
            }
            if (i_column == 1) {
                return this.a22;
            }
            if (i_column == 2) {
                return this.a23;
            }
            return this.a24;
        }
        if (i_row == 2) {
            if (i_column == 0) {
                return this.a31;
            }
            if (i_column == 1) {
                return this.a32;
            }
            if (i_column == 2) {
                return this.a33;
            }
            return this.a34;
        }
        if (i_column == 0) {
            return this.a41;
        }
        if (i_column == 1) {
            return this.a42;
        }
        if (i_column == 2) {
            return this.a43;
        }
        return this.a44;
    }

    public void set(int i_row, int i_column, float i_value) {
        if (i_row < 0 || i_row >= 4) {
            throw new IllegalArgumentException("row index out of bounds: " + i_row);
        }
        if (i_column < 0 || i_column >= 4) {
            throw new IllegalArgumentException("column index out of bounds: " + i_column);
        }
        if (i_row == 0) {
            if (i_column == 0) {
                this.a11 = i_value;
            } else if (i_column == 1) {
                this.a12 = i_value;
            } else if (i_column == 2) {
                this.a13 = i_value;
            } else {
                this.a14 = i_value;
            }
        } else if (i_row == 1) {
            if (i_column == 0) {
                this.a21 = i_value;
            } else if (i_column == 1) {
                this.a22 = i_value;
            } else if (i_column == 2) {
                this.a23 = i_value;
            } else {
                this.a24 = i_value;
            }
        } else if (i_row == 2) {
            if (i_column == 0) {
                this.a31 = i_value;
            } else if (i_column == 1) {
                this.a32 = i_value;
            } else if (i_column == 2) {
                this.a33 = i_value;
            } else {
                this.a34 = i_value;
            }
        } else if (i_column == 0) {
            this.a41 = i_value;
        } else if (i_column == 1) {
            this.a42 = i_value;
        } else if (i_column == 2) {
            this.a43 = i_value;
        } else {
            this.a44 = i_value;
        }
    }

    public void setColumnMajor(float[] i_arrayOfFloat) {
        this.a11 = i_arrayOfFloat[0];
        this.a21 = i_arrayOfFloat[1];
        this.a31 = i_arrayOfFloat[2];
        this.a41 = i_arrayOfFloat[3];
        this.a12 = i_arrayOfFloat[4];
        this.a22 = i_arrayOfFloat[5];
        this.a32 = i_arrayOfFloat[6];
        this.a42 = i_arrayOfFloat[7];
        this.a13 = i_arrayOfFloat[8];
        this.a23 = i_arrayOfFloat[9];
        this.a33 = i_arrayOfFloat[10];
        this.a43 = i_arrayOfFloat[11];
        this.a14 = i_arrayOfFloat[12];
        this.a24 = i_arrayOfFloat[13];
        this.a34 = i_arrayOfFloat[14];
        this.a44 = i_arrayOfFloat[15];
    }

    public void setColumnMajor(FloatBuffer i_floatBuffer) {
        this.a11 = i_floatBuffer.get();
        this.a21 = i_floatBuffer.get();
        this.a31 = i_floatBuffer.get();
        this.a41 = i_floatBuffer.get();
        this.a12 = i_floatBuffer.get();
        this.a22 = i_floatBuffer.get();
        this.a32 = i_floatBuffer.get();
        this.a42 = i_floatBuffer.get();
        this.a13 = i_floatBuffer.get();
        this.a23 = i_floatBuffer.get();
        this.a33 = i_floatBuffer.get();
        this.a43 = i_floatBuffer.get();
        this.a14 = i_floatBuffer.get();
        this.a24 = i_floatBuffer.get();
        this.a34 = i_floatBuffer.get();
        this.a44 = i_floatBuffer.get();
    }

    public void setIdentity() {
        this.a11 = 1.0f;
        this.a12 = 0.0f;
        this.a13 = 0.0f;
        this.a14 = 0.0f;
        this.a21 = 0.0f;
        this.a22 = 1.0f;
        this.a23 = 0.0f;
        this.a24 = 0.0f;
        this.a31 = 0.0f;
        this.a32 = 0.0f;
        this.a33 = 1.0f;
        this.a34 = 0.0f;
        this.a41 = 0.0f;
        this.a42 = 0.0f;
        this.a43 = 0.0f;
        this.a44 = 1.0f;
    }

    public void setRowMajor(float[] i_arrayOfFloat) {
        this.a11 = i_arrayOfFloat[0];
        this.a12 = i_arrayOfFloat[1];
        this.a13 = i_arrayOfFloat[2];
        this.a14 = i_arrayOfFloat[3];
        this.a21 = i_arrayOfFloat[4];
        this.a22 = i_arrayOfFloat[5];
        this.a23 = i_arrayOfFloat[6];
        this.a24 = i_arrayOfFloat[7];
        this.a31 = i_arrayOfFloat[8];
        this.a32 = i_arrayOfFloat[9];
        this.a33 = i_arrayOfFloat[10];
        this.a34 = i_arrayOfFloat[11];
        this.a41 = i_arrayOfFloat[12];
        this.a42 = i_arrayOfFloat[13];
        this.a43 = i_arrayOfFloat[14];
        this.a44 = i_arrayOfFloat[15];
    }

    public void setRowMajor(FloatBuffer i_floatBuffer) {
        this.a11 = i_floatBuffer.get();
        this.a12 = i_floatBuffer.get();
        this.a13 = i_floatBuffer.get();
        this.a14 = i_floatBuffer.get();
        this.a21 = i_floatBuffer.get();
        this.a22 = i_floatBuffer.get();
        this.a23 = i_floatBuffer.get();
        this.a24 = i_floatBuffer.get();
        this.a31 = i_floatBuffer.get();
        this.a32 = i_floatBuffer.get();
        this.a33 = i_floatBuffer.get();
        this.a34 = i_floatBuffer.get();
        this.a41 = i_floatBuffer.get();
        this.a42 = i_floatBuffer.get();
        this.a43 = i_floatBuffer.get();
        this.a44 = i_floatBuffer.get();
    }

    public void setZero() {
        this.a11 = 0.0f;
        this.a12 = 0.0f;
        this.a13 = 0.0f;
        this.a14 = 0.0f;
        this.a21 = 0.0f;
        this.a22 = 0.0f;
        this.a23 = 0.0f;
        this.a24 = 0.0f;
        this.a31 = 0.0f;
        this.a32 = 0.0f;
        this.a33 = 0.0f;
        this.a34 = 0.0f;
        this.a41 = 0.0f;
        this.a42 = 0.0f;
        this.a43 = 0.0f;
        this.a44 = 0.0f;
    }

    public int size() {
        return 16;
    }

    public void toArrayColumnMajor(float[] o_arrayOfFloat) {
        this.toArrayColumnMajor(o_arrayOfFloat, 0);
    }

    public void toArrayColumnMajor(float[] o_arrayOfFloat, int i_iOffset) {
        o_arrayOfFloat[i_iOffset++] = this.a11;
        o_arrayOfFloat[i_iOffset++] = this.a21;
        o_arrayOfFloat[i_iOffset++] = this.a31;
        o_arrayOfFloat[i_iOffset++] = this.a41;
        o_arrayOfFloat[i_iOffset++] = this.a12;
        o_arrayOfFloat[i_iOffset++] = this.a22;
        o_arrayOfFloat[i_iOffset++] = this.a32;
        o_arrayOfFloat[i_iOffset++] = this.a42;
        o_arrayOfFloat[i_iOffset++] = this.a13;
        o_arrayOfFloat[i_iOffset++] = this.a23;
        o_arrayOfFloat[i_iOffset++] = this.a33;
        o_arrayOfFloat[i_iOffset++] = this.a43;
        o_arrayOfFloat[i_iOffset++] = this.a14;
        o_arrayOfFloat[i_iOffset++] = this.a24;
        o_arrayOfFloat[i_iOffset++] = this.a34;
        o_arrayOfFloat[i_iOffset++] = this.a44;
    }

    public void toArrayRowMajor(float[] o_arrayOfFloat) {
        this.toArrayRowMajor(o_arrayOfFloat, 0);
    }

    public void toArrayRowMajor(float[] o_arrayOfFloat, int i_iOffset) {
        o_arrayOfFloat[i_iOffset++] = this.a11;
        o_arrayOfFloat[i_iOffset++] = this.a12;
        o_arrayOfFloat[i_iOffset++] = this.a13;
        o_arrayOfFloat[i_iOffset++] = this.a14;
        o_arrayOfFloat[i_iOffset++] = this.a21;
        o_arrayOfFloat[i_iOffset++] = this.a22;
        o_arrayOfFloat[i_iOffset++] = this.a23;
        o_arrayOfFloat[i_iOffset++] = this.a24;
        o_arrayOfFloat[i_iOffset++] = this.a31;
        o_arrayOfFloat[i_iOffset++] = this.a32;
        o_arrayOfFloat[i_iOffset++] = this.a33;
        o_arrayOfFloat[i_iOffset++] = this.a34;
        o_arrayOfFloat[i_iOffset++] = this.a41;
        o_arrayOfFloat[i_iOffset++] = this.a42;
        o_arrayOfFloat[i_iOffset++] = this.a43;
        o_arrayOfFloat[i_iOffset] = this.a44;
    }

    public void toBufferColumnMajor(FloatBuffer o_floatBuffer) {
        o_floatBuffer.put(this.a11);
        o_floatBuffer.put(this.a21);
        o_floatBuffer.put(this.a31);
        o_floatBuffer.put(this.a41);
        o_floatBuffer.put(this.a12);
        o_floatBuffer.put(this.a22);
        o_floatBuffer.put(this.a32);
        o_floatBuffer.put(this.a42);
        o_floatBuffer.put(this.a13);
        o_floatBuffer.put(this.a23);
        o_floatBuffer.put(this.a33);
        o_floatBuffer.put(this.a43);
        o_floatBuffer.put(this.a14);
        o_floatBuffer.put(this.a24);
        o_floatBuffer.put(this.a34);
        o_floatBuffer.put(this.a44);
    }

    public void toBufferRowMajor(FloatBuffer o_floatBuffer) {
        o_floatBuffer.put(this.a11);
        o_floatBuffer.put(this.a12);
        o_floatBuffer.put(this.a13);
        o_floatBuffer.put(this.a14);
        o_floatBuffer.put(this.a21);
        o_floatBuffer.put(this.a22);
        o_floatBuffer.put(this.a23);
        o_floatBuffer.put(this.a24);
        o_floatBuffer.put(this.a31);
        o_floatBuffer.put(this.a32);
        o_floatBuffer.put(this.a33);
        o_floatBuffer.put(this.a34);
        o_floatBuffer.put(this.a41);
        o_floatBuffer.put(this.a42);
        o_floatBuffer.put(this.a43);
        o_floatBuffer.put(this.a44);
    }

    public String toString() {
        return String.format("%n(%s, %s, %s, %s%n %s, %s, %s, %s%n %s, %s, %s, %s%n %s, %s, %s, %s)%n", String.valueOf(this.a11), String.valueOf(this.a12), String.valueOf(this.a13), String.valueOf(this.a14), String.valueOf(this.a21), String.valueOf(this.a22), String.valueOf(this.a23), String.valueOf(this.a24), String.valueOf(this.a31), String.valueOf(this.a32), String.valueOf(this.a33), String.valueOf(this.a34), String.valueOf(this.a41), String.valueOf(this.a42), String.valueOf(this.a43), String.valueOf(this.a44));
    }
}

