/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.testing.ide;

import java.util.ArrayList;
import java.util.List;
import org.ascape.runtime.Runner;
import org.eclipse.amp.amf.testing.ide.TestRunSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExecuteTestHandler
extends AbstractHandler {
    List<IResource> testResources;
    private IProject project;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.testResources = new ArrayList<IResource>();
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && ((StructuredSelection)selection).size() > 0) {
            IResource res = (IResource)((StructuredSelection)selection).getFirstElement();
            this.project = res.getProject();
            List selList = ((StructuredSelection)selection).toList();
            for (Object obj : selList) {
                if (!(obj instanceof IResource)) continue;
                this.addResource((IResource)obj);
            }
            Runner.setDisplayGraphics((boolean)false);
            new TestRunSet(this.project, res, this.testResources, this.getRunsPerTest()).run();
        }
        return null;
    }

    private void addResource(IResource res) {
        if (res instanceof IFile) {
            IFile file = (IFile)res;
            if (file.getFileExtension() != null && file.getFileExtension().equals("atest")) {
                this.testResources.add(res);
            }
        } else if (res instanceof IFolder) {
            IFolder folder = (IFolder)res;
            try {
                IResource[] iResourceArray = folder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resMember = iResourceArray[n2];
                    this.addResource(resMember);
                    ++n2;
                }
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public int getRunsPerTest() {
        return 1;
    }

    protected boolean handleSelect(Object sel) {
        return sel instanceof IResource && ((IResource)sel).getFileExtension() != null && ((IResource)sel).getFileExtension().equals("atest");
    }
}

