/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.space;

import java.io.Serializable;
import org.ascape.model.space.Coordinate;
import org.ascape.util.data.DataPointConcrete;

public abstract class CoordinateContinuous
extends Coordinate
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected double[] values;

    public CoordinateContinuous() {
    }

    public CoordinateContinuous(double[] values) {
        this.values = values;
    }

    public CoordinateContinuous(double value) {
        this.values = new double[1];
        this.values[0] = value;
    }

    public int getDimensionCount() {
        return this.values.length;
    }

    public final double[] getValues() {
        return this.values;
    }

    public final void setValues(double[] values) {
        this.values = values;
    }

    public final double getValueAtDimension(int dimension) {
        return this.values[dimension - 1];
    }

    public final void setValueAtDimension(int dimension, double value) {
        this.values[dimension - 1] = value;
    }

    public final double getProduct() {
        int size = 0;
        int i = 0;
        while (i < this.values.length) {
            size = (int)((double)size * this.values[i]);
            ++i;
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CoordinateContinuous && this.values.length == ((CoordinateContinuous)obj).values.length) {
            int i = 0;
            while (i < this.values.length) {
                if (!DataPointConcrete.equals(this.values[i], ((CoordinateContinuous)obj).values[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        String desc = "Coordinate with values: [";
        int i = 0;
        while (i < this.values.length) {
            desc = String.valueOf(desc) + this.values[i];
            if (i < this.values.length - 1) {
                desc = String.valueOf(desc) + ", ";
            }
            ++i;
        }
        desc = String.valueOf(desc) + this.values.length + "-dimensional geometry.";
        return desc;
    }
}

