/* Generated By:JJTree: Do not edit this line. QTField.java */

package org.ascape.query.parser;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;

public class QTField extends SimpleNode {

    private String name;
    private PropertyDescriptor descriptor;

    public QTField(int id) {
        super(id);
    }

    public QTField(BoolExprTree p, int id) {
        super(p, id);
    }

    public void validate(Object object) throws ParseException {
        try {
            //need all of these trys below because you cannot create a property descriptor for getters only w/o generating an error.
            try {
                descriptor = new PropertyDescriptor(getName(), object.getClass());
            } catch (IntrospectionException e) {
                //ok if we only have a getter method...
                String base = capitalize(getName());

                try {
                    descriptor = new PropertyDescriptor(getName(), object.getClass(), "is" + base, null);
                } catch (IntrospectionException e1) {
                    descriptor = new PropertyDescriptor(getName(), object.getClass(), "get" + base, null);
                }
            }
            getValue(object);
        } catch (IntrospectionException e) {
            throw new ParseException("Couldn't recognize field: " + getName() + " for class: " + object.getClass() + e);
        }
    }

    static String capitalize(String s) {
        if (s.length() == 0) {
            return s;
        }
        char chars[] = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public PropertyDescriptor getDescriptor() {
        return descriptor;
    }

    public Object getComparedValue(Object object) throws ParseException {
        Class type = getDescriptor().getPropertyType();
        Object value = getValue(object);
        if (!(value instanceof Number)
            && (type != String.class) && !(value instanceof Boolean)) {
            if (value != null) {
                value = value.toString();
            } else {
                value = "null";
            }
        }
        return value;
    }

    public Object getValue(Object object) throws ParseException {
        Object o = null;
        try {
            o = descriptor.getReadMethod().invoke(object, (Object[]) null);
        } catch (IllegalAccessException e) {
            throw new ParseException("Couldn't access field: " + getName() + " for class: " + object.getClass());  //To change body of catch statement use Options | File Templates.
        } catch (IllegalArgumentException e) {
            throw new ParseException("Couldn't make argument for field: " + getName() + " for class: " + object.getClass());  //To change body of catch statement use Options | File Templates.
        } catch (InvocationTargetException e) {
            e.getCause().printStackTrace();
            throw new ParseException("Couldn't target field: " + getName() + " for class: " + object.getClass() + " because: "+ e.getCause());
        }
        return o;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return name;
    }
}
