/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.commands;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.metaabm.IID;
import org.metaabm.MetaABMPackage;
import org.metaabm.SAgent;
import org.metaabm.SContext;
import org.metaabm.SImplementationMode;
import org.metaabm.SImplemented;
import org.metaabm.SNamed;
import org.metaabm.SProjection;
import org.metaabm.commands.TargetTranslator;

public class SetLabelCommand
extends SetCommand {
    IID source;
    List<TargetTranslator> translators;
    Command dependentCommands;

    public SetLabelCommand(EditingDomain domain, List<TargetTranslator> translators, EObject owner, EStructuralFeature feature, Object value, int index) {
        super(domain, owner, feature, value, index);
        this.source = (IID)owner;
        this.translators = translators;
    }

    public SetLabelCommand(final EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index) {
        super(domain, owner, feature, value, index);
        this.source = (IID)owner;
        this.translators = new ArrayList<TargetTranslator>(this.translatorsFor(this.source, feature));
        CollectionUtils.filter(this.translators, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                boolean includeFor = ((TargetTranslator)object).includeFor(domain, (EObject)SetLabelCommand.this.source);
                return includeFor;
            }
        });
    }

    public Command createDependent() {
        CompoundCommand cmd = new CompoundCommand();
        for (TargetTranslator translator : this.translators) {
            Command created = translator.createCommand(this.domain, (IID)this.owner);
            cmd.appendAndExecute(created);
        }
        return cmd;
    }

    public List<TargetTranslator> translatorsFor(IID source, EStructuralFeature feature) {
        if (feature == MetaABMPackage.Literals.IID__LABEL) {
            if (source instanceof SAgent && (((SAgent)source).getOwner() == null || ((SAgent)source).getOwner().getImplementation().getMode() != SImplementationMode.GENERATE_LITERAL)) {
                return TargetTranslator.NAMED_IMPLEMENTED_TRANSLATORS;
            }
            if (source instanceof SAgent) {
                return TargetTranslator.AGENT_TRANSLATORS;
            }
            if (source instanceof SProjection) {
                return TargetTranslator.SAPCE_TRANSLATORS;
            }
            if (source instanceof SImplemented && source instanceof SNamed) {
                return TargetTranslator.NAMED_IMPLEMENTED_TRANSLATORS;
            }
            if (source instanceof SImplemented) {
                return TargetTranslator.IMPLEMENTED_TRANSLATORS;
            }
            if (source instanceof SNamed) {
                return TargetTranslator.NAMED_TRANSLATORS;
            }
            if (source instanceof IID) {
                return TargetTranslator.ID_TRANSLATORS;
            }
        } else if (feature == MetaABMPackage.Literals.SNAMED__PLURAL_LABEL) {
            if (source instanceof SContext && ((SAgent)source).getOwner() != null && ((SAgent)source).getOwner().getImplementation().getMode() == SImplementationMode.GENERATE_LITERAL) {
                return TargetTranslator.PLURAL_TRANSLATORS;
            }
            return new ArrayList<TargetTranslator>();
        }
        throw new InternalError("Should not be possible to reach this line.");
    }

    public static Command create(EditingDomain domain, Object source, Object feature, Object value) {
        return SetLabelCommand.create(domain, source, feature, value, -1);
    }

    public static Command create(EditingDomain domain, Object source, Object value) {
        return SetLabelCommand.create(domain, source, MetaABMPackage.Literals.IID__LABEL, value, -1);
    }

    public static Command create(EditingDomain domain, Object source, Object feature, Object value, int index) {
        Object container;
        EObject eSource = (EObject)source;
        if (eSource.eContainer() != null && (container = eSource.eContainer().eGet(eSource.eContainingFeature())) instanceof EList) {
            value = SetLabelCommand.uniqueIn(source, (List)container, (String)value);
        }
        SetLabelCommand setLabelCommand = new SetLabelCommand(domain, (EObject)source, (EStructuralFeature)feature, value, index);
        setLabelCommand.prepare();
        return setLabelCommand;
    }

    public void doExecute() {
        super.doExecute();
        this.dependentCommands = this.createDependent();
    }

    public void doRedo() {
        super.doRedo();
        this.dependentCommands.redo();
    }

    public void doUndo() {
        this.dependentCommands.undo();
        super.doUndo();
    }

    private static Object uniqueIn(Object source, List<?> container, String proposed) {
        for (Object object : container) {
            if (source == object || ((IID)object).getLabel() == null || !((IID)object).getLabel().equals(proposed)) continue;
            return SetLabelCommand.uniqueIn(source, container, String.valueOf(proposed) + " Copy");
        }
        return proposed;
    }
}

