/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.util.vis;

import java.util.HashMap;
import java.util.Map;
import org.ascape.model.AscapeObject;
import org.ascape.util.vis.ColorFeature;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public abstract class ColorFeatureConcrete
implements Cloneable,
ColorFeature {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected static Map<RGB, Color> colorCache = new HashMap<RGB, Color>();

    public ColorFeatureConcrete() {
        AscapeObject.PLATFORM_DEFAULT_COLOR = BLACK;
    }

    public ColorFeatureConcrete(String name) {
        AscapeObject.PLATFORM_DEFAULT_COLOR = BLACK;
        this.name = name;
    }

    public static final Color create(RGB rgb) {
        Color color = colorCache.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb.red, rgb.green, rgb.blue);
            colorCache.put(rgb, color);
        }
        return color;
    }

    public static final Color create(int r, int g, int b) {
        return ColorFeatureConcrete.create(new RGB(r, g, b));
    }

    public static final Color create(float r, float g, float b) {
        return ColorFeatureConcrete.create((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    public static final Color create(int r, int g, int b, int a) {
        return new Color((Device)Display.getCurrent(), r, g, b);
    }

    public static Color adjustBrightness(Color color, float factor) {
        float[] agentHSB = color.getRGB().getHSB();
        float newBright = Math.min(1.0f, agentHSB[2] * factor);
        Color brighter = ColorFeatureConcrete.createHSB(agentHSB[0], agentHSB[1], newBright);
        return brighter;
    }

    public static final Color createHSB(float hue, float sat, float brightness) {
        return ColorFeatureConcrete.create(new RGB(hue, sat, brightness));
    }

    public static final Color createRandom() {
        return ColorFeatureConcrete.create((float)Math.random(), (float)Math.random(), (float)Math.random());
    }

    public String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    @Override
    public abstract Color getColor(Object var1);
}

