/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.space;

import java.util.List;
import org.ascape.model.space.Array2D;
import org.ascape.model.space.Coordinate;
import org.ascape.model.space.Coordinate2DDiscrete;
import org.ascape.model.space.CoordinateDiscrete;
import org.ascape.model.space.Geometry;
import org.ascape.model.space.Node;

public class Array2DVonNeumann
extends Array2D {
    private static final long serialVersionUID = 1L;

    public Array2DVonNeumann() {
        this.setGeometry(new Geometry(2, true, -2));
    }

    public Array2DVonNeumann(CoordinateDiscrete extent) {
        this();
        this.setExtent(extent);
    }

    @Override
    public Node findCellToward(Node originCell, Node targetCell) {
        if (originCell == targetCell) {
            return originCell;
        }
        int ox = ((Coordinate2DDiscrete)originCell.getCoordinate()).getXValue();
        int oy = ((Coordinate2DDiscrete)originCell.getCoordinate()).getYValue();
        int tx = ((Coordinate2DDiscrete)targetCell.getCoordinate()).getXValue();
        int ty = ((Coordinate2DDiscrete)targetCell.getCoordinate()).getYValue();
        if (!this.getGeometry().isPeriodic()) {
            if (Math.abs(ox - tx) == Math.abs(tx - ox)) {
                if (this.randomIs()) {
                    tx = ox;
                } else {
                    ty = oy;
                }
            }
            if (Math.abs(ox - tx) > Math.abs(tx - ox)) {
                if (ox > tx) {
                    --ox;
                } else if (ox < tx) {
                    ++ox;
                }
            } else if (oy > ty) {
                --oy;
            } else if (oy < ty) {
                ++oy;
            }
        } else {
            int ex = this.getXSize();
            int ey = this.getYSize();
            if (ox > tx) {
                ox = ox - tx < tx + (ex - ox) ? --ox : ++ox;
            } else if (ox < tx) {
                ox = tx - ox < ox + (ex - tx) ? ++ox : --ox;
            }
            if (oy > ty) {
                oy = oy - ty < ty + (ey - oy) ? --oy : ++oy;
            } else if (oy < ty) {
                oy = ty - oy < oy + (ey - ty) ? ++oy : --oy;
            }
            if (ox >= ex) {
                ox = 0;
            } else if (ox < 0) {
                ox = ex - 1;
            }
            if (oy >= ey) {
                oy = 0;
            } else if (oy < 0) {
                oy = ey - 1;
            }
        }
        return this.get(ox, oy);
    }

    @Override
    public Node findCellAway(Node originCell, Node targetCell) {
        if (originCell == targetCell) {
            return originCell.findRandomNeighbor();
        }
        int ox = ((Coordinate2DDiscrete)originCell.getCoordinate()).getXValue();
        int oy = ((Coordinate2DDiscrete)originCell.getCoordinate()).getYValue();
        int tx = ((Coordinate2DDiscrete)targetCell.getCoordinate()).getXValue();
        int ty = ((Coordinate2DDiscrete)targetCell.getCoordinate()).getYValue();
        int ex = this.getXSize();
        int ey = this.getYSize();
        int rx = ex / 2;
        int ry = ey / 2;
        int dx = tx - ox;
        if (dx > 0) {
            ox = dx < rx - 1 ? (ox > 0 ? --ox : ex - 1) : (ox < ex - 1 ? ++ox : 0);
        } else if (dx < 0) {
            ox = dx > -rx - 1 ? (ox < ex - 1 ? ++ox : 0) : (ox > 0 ? --ox : ex - 1);
        }
        int dy = ty - oy;
        if (dy > 0) {
            oy = dy < ry - 1 ? (oy > 0 ? --oy : ey - 1) : (oy < ey - 1 ? ++oy : 0);
        } else if (dy < 0) {
            oy = dy > -ry - 1 ? (oy < ey - 1 ? ++oy : 0) : (oy > 0 ? --oy : ey - 1);
        }
        Node dCell = this.get(ox, oy);
        if (dCell.isAvailable()) {
            return dCell;
        }
        if (this.randomIs()) {
            dCell = this.get(((Coordinate2DDiscrete)originCell.getCoordinate()).getXValue(), oy);
            if (dCell.isAvailable()) {
                return dCell;
            }
            dCell = this.get(ox, ((Coordinate2DDiscrete)originCell.getCoordinate()).getYValue());
            if (dCell.isAvailable()) {
                return dCell;
            }
        } else {
            dCell = this.get(ox, ((Coordinate2DDiscrete)originCell.getCoordinate()).getYValue());
            if (dCell.isAvailable()) {
                return dCell;
            }
            dCell = this.get(((Coordinate2DDiscrete)originCell.getCoordinate()).getXValue(), oy);
            if (dCell.isAvailable()) {
                return dCell;
            }
        }
        return originCell;
    }

    @Override
    public List findWithinImpl(Coordinate origin, boolean includeSelf, double distance) {
        return this.findWithinVonNeumann(origin, includeSelf, distance);
    }

    @Override
    public double calculateDistance(Coordinate origin, Coordinate target) {
        if (!this.nearnessLineOfSight) {
            return this.getXSpan(origin, target) + this.getYSpan(origin, target);
        }
        if (this.getXSpan(origin, target) == 0) {
            return this.getYSpan(origin, target);
        }
        if (this.getYSpan(origin, target) == 0) {
            return this.getXSpan(origin, target);
        }
        return 2.147483647E9;
    }
}

