/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.ast.ocl.environment;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.common.internal.utils.AcceleoPackageRegistry;
import org.eclipse.acceleo.common.internal.utils.compatibility.AcceleoCompatibilityHelper;
import org.eclipse.acceleo.common.internal.utils.compatibility.AcceleoOCLReflection;
import org.eclipse.acceleo.common.internal.utils.compatibility.OCLVersion;
import org.eclipse.acceleo.common.utils.AcceleoNonStandardLibrary;
import org.eclipse.acceleo.common.utils.AcceleoStandardLibrary;
import org.eclipse.acceleo.common.utils.CircularArrayDeque;
import org.eclipse.acceleo.common.utils.Deque;
import org.eclipse.acceleo.internal.compatibility.parser.ast.ocl.environment.AcceleoUMLReflectionHelios;
import org.eclipse.acceleo.internal.parser.ast.ocl.environment.AcceleoTypeResolver;
import org.eclipse.acceleo.internal.parser.ast.ocl.environment.AcceleoUMLReflection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.AmbiguousLookupException;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.TypeResolver;
import org.eclipse.ocl.ecore.BagType;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.OrderedSetType;
import org.eclipse.ocl.ecore.PrimitiveType;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.SequenceType;
import org.eclipse.ocl.ecore.SetType;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ProblemOption;
import org.eclipse.ocl.parser.AbstractOCLAnalyzer;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;

public class AcceleoEnvironment
extends EcoreEnvironment {
    private AcceleoNonStandardLibrary acceleoNonStdLib;
    private AcceleoStandardLibrary acceleoStdLib;
    private Object firstProblemObject;
    private int generatorInt;
    private List<EPackage> metamodels = new ArrayList<EPackage>();
    private AcceleoOCLReflection oclStdLibReflection;
    private final Deque<Map<String, Deque<VariableEntry>>> scopedVariableMap = new CircularArrayDeque();
    private List<EClassifier> types = new ArrayList<EClassifier>();
    private UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> umlReflection;

    public AcceleoEnvironment(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> parent) {
        super(parent);
        if (!(parent instanceof AcceleoEnvironment)) {
            this.addAdditionalOperations();
        }
        this.scopedVariableMap.add(new HashMap());
    }

    public AcceleoEnvironment(Resource oclEnvironmentResource) {
        super((EPackage.Registry)AcceleoPackageRegistry.INSTANCE, oclEnvironmentResource);
        this.addAdditionalOperations();
        this.scopedVariableMap.add(new HashMap());
    }

    public boolean addElement(String name, Variable<EClassifier, EParameter> elem, boolean isExplicit) {
        Map last;
        Deque deque;
        String newName = name;
        if (newName == null) {
            newName = this.generateName();
            while (this.lookup(newName) != null) {
                newName = this.generateName();
            }
        }
        if ((deque = (Deque)(last = (Map)this.scopedVariableMap.getLast()).get(newName)) == null) {
            deque = new CircularArrayDeque();
            last.put(newName, deque);
        }
        this.getUMLReflection().setName(elem, newName);
        VariableEntry newelem = new VariableEntry(newName, elem, isExplicit);
        this.addedVariable(newName, elem, isExplicit);
        return deque.add((Object)newelem);
    }

    public void addHelperOperations(EClassifier owner, List<EOperation> operations) {
        for (EOperation operation : operations) {
            this.addHelperOperation(owner, operation);
        }
    }

    public void addMetamodel(EPackage metamodel) {
        this.metamodels.add(metamodel);
        this.types.clear();
    }

    public void analyzerError(String problemMessage, String problemContext, List<?> problemObjects) {
        if (problemObjects != null && problemObjects.size() > 0) {
            this.setFirstProblemObjectIfNull(problemObjects.get(0));
        }
        super.analyzerError(problemMessage, problemContext, problemObjects);
    }

    public void analyzerError(String problemMessage, String problemContext, Object problemObject) {
        this.setFirstProblemObjectIfNull(problemObject);
        super.analyzerError(problemMessage, problemContext, problemObject);
    }

    public void createVariableScope() {
        this.scopedVariableMap.add(new HashMap());
    }

    public void deleteElement(String name) {
        Map last = (Map)this.scopedVariableMap.getLast();
        Deque deque = (Deque)last.get(name);
        if (deque != null && !deque.isEmpty()) {
            deque.removeLast();
        }
        if (deque != null && deque.isEmpty()) {
            last.remove(name);
        }
    }

    public void deleteFirstProblemObject() {
        this.firstProblemObject = null;
        if (this.getInternalParent() instanceof AcceleoEnvironment) {
            ((AcceleoEnvironment)this.getInternalParent()).deleteFirstProblemObject();
        }
    }

    public void dispose() {
        super.dispose();
        this.acceleoNonStdLib = null;
        this.acceleoStdLib = null;
        this.firstProblemObject = null;
        this.metamodels.clear();
        this.metamodels = null;
        this.oclStdLibReflection = null;
        this.types.clear();
        this.types = null;
        this.umlReflection = null;
    }

    public AcceleoNonStandardLibrary getAcceleoNonStandardLibrary() {
        if (this.acceleoNonStdLib == null) {
            this.acceleoNonStdLib = new AcceleoNonStandardLibrary();
        }
        return this.acceleoNonStdLib;
    }

    public AcceleoStandardLibrary getAcceleoStandardLibrary() {
        if (this.acceleoStdLib == null) {
            this.acceleoStdLib = new AcceleoStandardLibrary();
        }
        return this.acceleoStdLib;
    }

    public List<EOperation> getAdditionalOperations(EClassifier classifier) {
        ArrayList<EOperation> result = new ArrayList<EOperation>();
        result.addAll(super.getAdditionalOperations((Object)classifier));
        if (!(classifier instanceof PrimitiveType)) {
            result.addAll(super.getAdditionalOperations((Object)EcorePackage.eINSTANCE.getEObject()));
        }
        return result;
    }

    public List<EOperation> getAdditionalOperations(EClassifier classifier, String name) {
        Iterable<Object> candidates;
        Environment.Internal parent = this.getInternalParent();
        if (parent instanceof AcceleoEnvironment) {
            return ((AcceleoEnvironment)parent).getAdditionalOperations(classifier, name);
        }
        TypeResolver typeResolver = this.getTypeResolver();
        if (parent != null) {
            candidates = parent.getAdditionalOperations((Object)classifier);
        } else {
            List<EOperation> additionals = typeResolver instanceof AcceleoTypeResolver ? ((AcceleoTypeResolver)typeResolver).getAdditionalOperations(classifier, name) : typeResolver.getAdditionalOperations((Object)classifier);
            candidates = !additionals.isEmpty() ? additionals : new ArrayList<EOperation>();
        }
        Collection allParents = classifier instanceof PredefinedType ? OCLStandardLibraryUtil.getAllSupertypes((Environment)this, (PredefinedType)((PredefinedType)classifier)) : this.getUMLReflection().getAllSupertypes((Object)classifier);
        for (EClassifier general : allParents) {
            List<EOperation> additionals = typeResolver instanceof AcceleoTypeResolver ? ((AcceleoTypeResolver)typeResolver).getAdditionalOperations(general, name) : typeResolver.getAdditionalOperations((Object)general);
            if (additionals.isEmpty()) continue;
            candidates = Iterables.concat(candidates, additionals);
        }
        if (candidates == null) {
            candidates = Collections.emptyList();
        }
        ArrayList<EOperation> result = new ArrayList<EOperation>();
        for (EOperation candidate : candidates) {
            if (!name.equals(candidate.getName())) continue;
            result.add(candidate);
        }
        return result;
    }

    public Object getFirstProblemObject() {
        Object result = this.firstProblemObject != null ? this.firstProblemObject : (this.getInternalParent() instanceof AcceleoEnvironment ? ((AcceleoEnvironment)this.getInternalParent()).getFirstProblemObject() : null);
        return result;
    }

    public AcceleoOCLReflection getOCLStandardLibraryReflection() {
        if (this.oclStdLibReflection == null) {
            this.oclStdLibReflection = new AcceleoOCLReflection((EcoreEnvironment)this);
        }
        return this.oclStdLibReflection;
    }

    public List<EClassifier> getTypes() {
        if (this.types.isEmpty()) {
            LinkedHashSet temp = Sets.newLinkedHashSet();
            List<EPackage> packages = this.getMetamodels();
            int size = packages.size();
            int i = 0;
            while (i < size) {
                EPackage ePackage = packages.get(i);
                EList classifiers = ePackage.getEClassifiers();
                int classCount = classifiers.size();
                int j = 0;
                while (j < classCount) {
                    this.computeOCLType(temp, (EClassifier)classifiers.get(j));
                    ++j;
                }
                ++i;
            }
            this.computeOCLType(temp, (EClassifier)this.getOCLStandardLibrary().getBag());
            this.computeOCLType(temp, (EClassifier)this.getOCLStandardLibrary().getBoolean());
            this.computeOCLType(temp, (EClassifier)this.getOCLStandardLibrary().getCollection());
            this.computeOCLType(temp, (EClassifier)this.getOCLStandardLibrary().getInteger());
            this.computeOCLType(temp, this.getOCLStandardLibraryReflection().getOCLInvalid());
            this.computeOCLType(temp, (EClassifier)this.getOCLStandardLibrary().getOclAny());
            this.computeOCLType(temp, (EClassifier)this.getOCLStandardLibrary().getOclElement());
            this.computeOCLType(temp, (EClassifier)this.getOCLStandardLibrary().getOclExpression());
            this.computeOCLType(temp, (EClassifier)this.getOCLStandardLibrary().getOclMessage());
            this.computeOCLType(temp, (EClassifier)this.getOCLStandardLibrary().getOclType());
            this.computeOCLType(temp, (EClassifier)this.getOCLStandardLibrary().getOclVoid());
            this.computeOCLType(temp, (EClassifier)this.getOCLStandardLibrary().getOrderedSet());
            this.computeOCLType(temp, (EClassifier)this.getOCLStandardLibrary().getReal());
            this.computeOCLType(temp, (EClassifier)this.getOCLStandardLibrary().getSequence());
            this.computeOCLType(temp, (EClassifier)this.getOCLStandardLibrary().getSet());
            this.computeOCLType(temp, (EClassifier)this.getOCLStandardLibrary().getState());
            this.computeOCLType(temp, (EClassifier)this.getOCLStandardLibrary().getString());
            this.computeOCLType(temp, (EClassifier)this.getOCLStandardLibrary().getT());
            this.computeOCLType(temp, (EClassifier)this.getOCLStandardLibrary().getT2());
            this.computeOCLType(temp, (EClassifier)this.getOCLStandardLibrary().getUnlimitedNatural());
            this.types = Lists.newArrayList((Iterable)temp);
        }
        return this.types;
    }

    public UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> getUMLReflection() {
        if (this.umlReflection == null) {
            this.umlReflection = AcceleoCompatibilityHelper.getCurrentVersion() == OCLVersion.HELIOS ? new AcceleoUMLReflectionHelios((UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint>)super.getUMLReflection()) : new AcceleoUMLReflection((UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint>)super.getUMLReflection());
        }
        return this.umlReflection;
    }

    public Collection<Variable<EClassifier, EParameter>> getVariables() {
        ArrayList<Variable<EClassifier, EParameter>> result = new ArrayList<Variable<EClassifier, EParameter>>();
        Map last = (Map)this.scopedVariableMap.getLast();
        Collection values = last.values();
        for (Deque deque : values) {
            for (VariableEntry variableEntry : deque) {
                if (!variableEntry.isExplicit) continue;
                result.add(variableEntry.variable);
            }
        }
        if (this.getInternalParent() != null) {
            for (Variable parentVar : this.getInternalParent().getVariables()) {
                if (this.lookupLocal(parentVar.getName()) != null) continue;
                result.add((Variable<EClassifier, EParameter>)parentVar);
            }
        }
        return result;
    }

    public boolean isEmpty() {
        return this.scopedVariableMap.isEmpty();
    }

    public EClassifier lookupClassifier(List<String> names) {
        EClassifier classifier = null;
        int nameCount = names.size();
        if (nameCount > 0) {
            List<EClassifier> classifiers = this.getTypes();
            int size = classifiers.size();
            int i = 0;
            while (i < size && classifier == null) {
                EClassifier eClassifier = classifiers.get(i);
                if (names.get(nameCount - 1).equals(eClassifier.getName()) && (nameCount < 2 || names.get(nameCount - 2).equals(eClassifier.getEPackage().getName()))) {
                    classifier = eClassifier;
                }
                ++i;
            }
            if (classifier == null) {
                classifier = super.lookupClassifier(names);
            }
        }
        return classifier;
    }

    public EClassifier lookupClassifier(String name) {
        EClassifier classifier = null;
        if (name != null && (classifier = this.lookupSequenceClassifier(name)) == null) {
            ArrayList<String> names = new ArrayList<String>();
            int eNamespace = name.indexOf("::");
            if (eNamespace > -1) {
                String packageName = name.substring(0, eNamespace).trim();
                String className = name.substring(eNamespace + "::".length()).trim();
                names.add(packageName);
                names.add(className);
            } else {
                names.add(name);
            }
            classifier = this.lookupClassifier(names);
        }
        if (classifier != null) {
            classifier = (EClassifier)this.getUMLReflection().getOCLType((Object)classifier);
        }
        return classifier;
    }

    public Variable<EClassifier, EParameter> lookupImplicitSourceForAssociationClass(String name) {
        EClassifier owner;
        Variable<EClassifier, EParameter> vdlc = null;
        boolean found = false;
        Map last = (Map)this.scopedVariableMap.getLast();
        Collection values = last.values();
        for (Deque deque : values) {
            for (VariableEntry variableEntry : deque) {
                EClassifier reference;
                vdlc = variableEntry.variable;
                EClassifier owner2 = (EClassifier)vdlc.getType();
                if (variableEntry.isExplicit || owner2 == null || (reference = (EClassifier)this.lookupAssociationClassReference(owner2, name)) == null) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        if (!found && (vdlc = this.getSelfVariable()) != null && (owner = (EClassifier)vdlc.getType()) != null && this.lookupAssociationClassReference(owner, name) != null) {
            return vdlc;
        }
        return vdlc;
    }

    public Variable<EClassifier, EParameter> lookupImplicitSourceForOperation(String name, List<? extends TypedElement<EClassifier>> args) {
        EClassifier owner;
        Variable<EClassifier, EParameter> vdlc = null;
        boolean found = false;
        Map last = (Map)this.scopedVariableMap.getLast();
        Collection values = last.values();
        for (Deque deque : values) {
            for (VariableEntry variableEntry : deque) {
                EOperation operation;
                vdlc = variableEntry.variable;
                EClassifier owner2 = (EClassifier)vdlc.getType();
                if (variableEntry.isExplicit || owner2 == null || (operation = this.lookupOperation(owner2, name, args)) == null) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        if (!found && (vdlc = this.getSelfVariable()) != null && (owner = (EClassifier)vdlc.getType()) != null && this.lookupOperation(owner, name, args) != null) {
            return vdlc;
        }
        return vdlc;
    }

    public Variable<EClassifier, EParameter> lookupImplicitSourceForProperty(String name) {
        EClassifier owner;
        Variable<EClassifier, EParameter> vdlc = null;
        boolean found = false;
        Map last = (Map)this.scopedVariableMap.getLast();
        Collection values = last.values();
        for (Deque deque : values) {
            for (VariableEntry variableEntry : deque) {
                EStructuralFeature property;
                vdlc = variableEntry.variable;
                EClassifier owner2 = (EClassifier)vdlc.getType();
                if (variableEntry.isExplicit || owner2 == null || (property = this.safeTryLookupProperty(owner2, name)) == null) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        if (!found && (vdlc = this.getSelfVariable()) != null && (owner = (EClassifier)vdlc.getType()) != null && this.safeTryLookupProperty(owner, name) != null) {
            return vdlc;
        }
        return vdlc;
    }

    public Variable<EClassifier, EParameter> lookupImplicitSourceForSignal(String name, List<? extends TypedElement<EClassifier>> args) {
        EClassifier owner;
        Variable<EClassifier, EParameter> vdlc = null;
        boolean found = false;
        Map last = (Map)this.scopedVariableMap.getLast();
        Collection values = last.values();
        for (Deque deque : values) {
            for (VariableEntry variableEntry : deque) {
                EClassifier signal;
                vdlc = variableEntry.variable;
                EClassifier owner2 = (EClassifier)vdlc.getType();
                if (variableEntry.isExplicit || owner2 == null || (signal = (EClassifier)this.lookupSignal(owner2, name, args)) == null) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        if (!found && (vdlc = this.getSelfVariable()) != null && (owner = (EClassifier)vdlc.getType()) != null && this.lookupSignal(owner, name, args) != null) {
            return vdlc;
        }
        return vdlc;
    }

    public Variable<EClassifier, EParameter> lookupImplicitSourceForState(List<String> path) throws LookupException {
        EClassifier owner;
        Variable<EClassifier, EParameter> vdlc = null;
        boolean found = true;
        Map last = (Map)this.scopedVariableMap.getLast();
        Collection values = last.values();
        for (Deque deque : values) {
            for (VariableEntry variableEntry : deque) {
                EObject state;
                vdlc = variableEntry.variable;
                EClassifier owner2 = (EClassifier)vdlc.getType();
                if (variableEntry.isExplicit || owner2 == null || (state = (EObject)this.lookupState(owner2, path)) == null) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        if (!found && (vdlc = this.getSelfVariable()) != null && (owner = (EClassifier)vdlc.getType()) != null && this.lookupState(owner, path) != null) {
            return vdlc;
        }
        return vdlc;
    }

    public Variable<EClassifier, EParameter> lookupLocal(String name) {
        Deque deque;
        Map last = (Map)this.scopedVariableMap.getLast();
        if (last != null && (deque = (Deque)last.get(name)) != null && !deque.isEmpty()) {
            VariableEntry variableEntry = (VariableEntry)deque.getLast();
            return variableEntry.variable;
        }
        return null;
    }

    public EOperation lookupOperation(EClassifier owner, String name, List<? extends TypedElement<EClassifier>> args) {
        EOperation oper = (EOperation)super.lookupOperation((Object)owner, name, args);
        if (oper == null) {
            if (owner instanceof SequenceType) {
                oper = (EOperation)super.lookupOperation((Object)((EClassifier)this.getOCLStandardLibrary().getSequence()), name, args);
            } else if (owner instanceof BagType) {
                oper = (EOperation)super.lookupOperation((Object)((EClassifier)this.getOCLStandardLibrary().getBag()), name, args);
            } else if (owner instanceof OrderedSetType) {
                oper = (EOperation)super.lookupOperation((Object)((EClassifier)this.getOCLStandardLibrary().getOrderedSet()), name, args);
            } else if (owner instanceof SetType) {
                oper = (EOperation)super.lookupOperation((Object)((EClassifier)this.getOCLStandardLibrary().getSet()), name, args);
            } else if (owner instanceof CollectionType) {
                oper = (EOperation)super.lookupOperation((Object)((EClassifier)this.getOCLStandardLibrary().getCollection()), name, args);
            }
        }
        if (oper == null && !(owner instanceof PrimitiveType)) {
            oper = (EOperation)super.lookupOperation((Object)EcorePackage.eINSTANCE.getEObject(), name, args);
        }
        return oper;
    }

    public void removeMetamodel(EPackage metamodel) {
        this.metamodels.remove(metamodel);
        this.types.clear();
    }

    public void setFactory(EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> factory) {
        super.setFactory(factory);
    }

    public EStructuralFeature tryLookupProperty(EClassifier owner, String name) throws LookupException {
        EStructuralFeature result = (EStructuralFeature)this.lookupProperty(owner, name);
        if (result == null && (result = this.lookupNonNavigableEnd(owner, name)) == null && AbstractOCLAnalyzer.isEscaped((String)name)) {
            result = this.lookupNonNavigableEnd(owner, AbstractOCLAnalyzer.unescape((String)name));
        }
        return result;
    }

    protected void findNonNavigableAssociationEnds(EClassifier classifier, String name, List<EStructuralFeature> ends) {
    }

    protected void findUnnamedAssociationEnds(EClassifier classifier, String name, List<EStructuralFeature> ends) {
    }

    protected List<EPackage> getMetamodels() {
        ArrayList<EPackage> metamodelsInScope = new ArrayList<EPackage>(this.metamodels);
        Environment.Internal parent = this.getInternalParent();
        while (parent != null) {
            if (parent instanceof AcceleoEnvironment) {
                metamodelsInScope.addAll(((AcceleoEnvironment)parent).getMetamodels());
                break;
            }
            parent = this.getInternalParent();
        }
        return metamodelsInScope;
    }

    protected EStructuralFeature lookupNonNavigableEnd(EClassifier owner, String name) throws LookupException {
        EClassifier tmpOwner = owner;
        if (tmpOwner == null) {
            Variable<EClassifier, EParameter> vdcl = this.lookupImplicitSourceForProperty(name);
            if (vdcl == null) {
                return null;
            }
            tmpOwner = (EClassifier)vdcl.getType();
        }
        ArrayList<EStructuralFeature> matches = new ArrayList<EStructuralFeature>(2);
        this.findNonNavigableAssociationEnds(tmpOwner, name, matches);
        if (matches.isEmpty()) {
            this.findUnnamedAssociationEnds(tmpOwner, name, matches);
        }
        EStructuralFeature result = null;
        if (matches.size() > 0) {
            result = (EStructuralFeature)matches.get(0);
        }
        if (matches.size() > 1 && this.notOK((Option)ProblemOption.AMBIGUOUS_ASSOCIATION_ENDS)) {
            ProblemHandler.Severity sev = (ProblemHandler.Severity)this.getValue((Option)ProblemOption.AMBIGUOUS_ASSOCIATION_ENDS);
            String message = OCLMessages.bind((String)OCLMessages.Ambig_AssocEnd_, (Object)name, (Object)this.getUMLReflection().getName((Object)tmpOwner));
            if (sev.getDiagnosticSeverity() >= 4) {
                throw new AmbiguousLookupException(message, matches);
            }
            this.getProblemHandler().analyzerProblem(sev, message, "lookupNonNavigableProperty", -1, -1);
        }
        return result;
    }

    private void addAdditionalOperations() {
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getString(), (List<EOperation>)this.getAcceleoStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getString()));
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getInteger(), (List<EOperation>)this.getAcceleoStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getInteger()));
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getReal(), (List<EOperation>)this.getAcceleoStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getReal()));
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getString(), (List<EOperation>)this.getAcceleoNonStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getString()));
        this.addHelperOperations((EClassifier)EcorePackage.eINSTANCE.getEObject(), (List<EOperation>)this.getAcceleoNonStandardLibrary().getExistingOperations((EClassifier)EcorePackage.eINSTANCE.getEObject()));
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getOclAny(), (List<EOperation>)this.getAcceleoNonStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getOclAny()));
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getCollection(), (List<EOperation>)this.getAcceleoNonStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getCollection()));
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getSequence(), (List<EOperation>)this.getAcceleoNonStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getSequence()));
        this.addHelperOperations((EClassifier)this.getOCLStandardLibrary().getOrderedSet(), (List<EOperation>)this.getAcceleoNonStandardLibrary().getExistingOperations((EClassifier)this.getOCLStandardLibrary().getOrderedSet()));
    }

    private void computeOCLType(Set<EClassifier> result, EClassifier type) {
        EClassifier oclType = (EClassifier)this.getTypeResolver().resolve((Object)type);
        if (oclType != null) {
            result.add(oclType);
        } else {
            result.add(type);
        }
    }

    private String generateName() {
        ++this.generatorInt;
        return "temp" + this.generatorInt;
    }

    private EClassifier lookupSequenceClassifier(String name) {
        int iPar;
        if (name.endsWith(")") && (iPar = name.indexOf("(")) > -1) {
            String sequenceType = name.substring(0, iPar).trim();
            String elementType = name.substring(iPar + "(".length(), name.length() - ")".length()).trim();
            EClassifier elementClassifier = this.lookupClassifier(elementType);
            org.eclipse.ocl.types.CollectionType sequenceClassifier = null;
            if (elementClassifier != null && CollectionKind.getByName((String)sequenceType) != null) {
                sequenceClassifier = this.getTypeResolver().resolveCollectionType(CollectionKind.getByName((String)sequenceType), (Object)elementClassifier);
            }
            if (sequenceClassifier instanceof EClassifier) {
                return (EClassifier)sequenceClassifier;
            }
        }
        return null;
    }

    private EStructuralFeature safeTryLookupProperty(EClassifier owner, String name) {
        EStructuralFeature result;
        block2: {
            result = null;
            try {
                result = this.tryLookupProperty(owner, name);
            }
            catch (LookupException e) {
                if (e.getAmbiguousMatches().isEmpty()) break block2;
                result = (EStructuralFeature)e.getAmbiguousMatches().get(0);
            }
        }
        return result;
    }

    private void setFirstProblemObjectIfNull(Object problemObject) {
        if (this.firstProblemObject == null) {
            this.firstProblemObject = problemObject;
        }
        if (this.getInternalParent() instanceof AcceleoEnvironment) {
            ((AcceleoEnvironment)this.getInternalParent()).setFirstProblemObjectIfNull(problemObject);
        }
    }

    protected final class VariableEntry {
        final boolean isExplicit;
        final String name;
        final Variable<EClassifier, EParameter> variable;

        VariableEntry(String name, Variable<EClassifier, EParameter> variable, boolean isExplicit) {
            this.name = name;
            this.variable = variable;
            this.isExplicit = isExplicit;
        }

        public String toString() {
            String result = "VariableEntry[" + this.name + ", ";
            result = this.isExplicit ? String.valueOf(result) + "explicit, " : String.valueOf(result) + "implicit, ";
            result = String.valueOf(result) + this.variable + "]";
            return result;
        }
    }
}

