/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.impl.AbstractServiceProvider;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.runtime.lookup.basic.Service;
import org.eclipse.acceleo.query.services.FilterService;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;

public class ResourceServices
extends AbstractServiceProvider {
    @Override
    protected IService getService(Method method) {
        if ("getContents".equals(method.getName())) {
            return new GetContentsService(method, this);
        }
        return new Service(method, this);
    }

    public Resource eResource(EObject eObject) {
        return eObject.eResource();
    }

    public URI getURI(Resource resource) {
        return resource.getURI();
    }

    public List<EObject> getContents(Resource resource) {
        return new ArrayList<EObject>((Collection<EObject>)resource.getContents());
    }

    public List<EObject> getContents(Resource resource, final EClass type) {
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)resource.getContents(), (Predicate)new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return type.isSuperTypeOf(input.eClass());
            }
        }));
    }

    public String lastSegment(URI uri) {
        return uri.lastSegment();
    }

    public String fileExtension(URI uri) {
        return uri.fileExtension();
    }

    public Boolean isPlatformResource(URI uri) {
        return uri.isPlatformResource();
    }

    public Boolean isPlatformPlugin(URI uri) {
        return uri.isPlatformPlugin();
    }

    private static final class GetContentsService
    extends FilterService {
        private GetContentsService(Method serviceMethod, Object serviceInstance) {
            super(serviceMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            if (argTypes.get(0).getType() == EcorePackage.eINSTANCE.getEResource()) {
                if (argTypes.size() == 1) {
                    result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject())));
                } else if (argTypes.size() == 2) {
                    result.add(new SequenceType(queryEnvironment, new EClassifierType(queryEnvironment, ((EClassifierLiteralType)argTypes.get(1)).getType())));
                }
            } else {
                result.add(new SequenceType(queryEnvironment, services.nothing("Can only call getContents() on Resources, not on %s", argTypes.get(0))));
            }
            return result;
        }
    }
}

