/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.lookup.basic;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.ILookupEngine;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IServiceProvider;
import org.eclipse.acceleo.query.runtime.InvalidAcceleoPackageException;
import org.eclipse.acceleo.query.runtime.ServiceRegistrationResult;
import org.eclipse.acceleo.query.runtime.lookup.basic.Service;

public class BasicLookupEngine
implements ILookupEngine {
    private static final String INSTANTIATION_PROBLEM_MSG = "Couldn't instantiate class ";
    private static final String SET_CROSS_REFERENCER_METHOD_NAME = "setCrossReferencer";
    private static final String PACKAGE_PROBLEM_MSG = "No zero argument constructor found in class ";
    private final Map<Integer, Map<String, List<IService>>> services = new HashMap<Integer, Map<String, List<IService>>>();
    private final Map<Class<?>, Set<IService>> classToServices = new LinkedHashMap();
    private IReadOnlyQueryEnvironment queryEnvironment;
    private CrossReferenceProvider crossReferencer;

    public BasicLookupEngine(IReadOnlyQueryEnvironment queryEnvironment, CrossReferenceProvider crossReferencer) {
        this.queryEnvironment = queryEnvironment;
        this.crossReferencer = crossReferencer;
    }

    @Override
    public CrossReferenceProvider getCrossReferencer() {
        return this.crossReferencer;
    }

    protected Map<Integer, Map<String, List<IService>>> getServices() {
        return this.services;
    }

    protected Map<Class<?>, Set<IService>> getClassToServices() {
        return this.classToServices;
    }

    private List<IService> getOrCreateMultimethod(String methodName, int argc) {
        List<IService> result;
        Map<String, List<IService>> argcServices = this.services.get(argc);
        if (argcServices == null) {
            argcServices = new HashMap<String, List<IService>>();
            this.services.put(argc, argcServices);
        }
        if ((result = argcServices.get(methodName)) == null) {
            result = new ArrayList<IService>();
            argcServices.put(methodName, result);
        }
        return result;
    }

    private List<IService> getMultimethod(String methodName, int argc) {
        Map<String, List<IService>> argcServices = this.services.get(argc);
        if (argcServices == null) {
            return null;
        }
        return argcServices.get(methodName);
    }

    private boolean matches(Method method, Class<?>[] argumentTypes) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != argumentTypes.length) {
            throw new IllegalArgumentException("the specified method doesn't have the right parameter number");
        }
        int i = 0;
        while (i < parameterTypes.length) {
            if (argumentTypes[i] != null && !parameterTypes[i].isAssignableFrom(argumentTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isLowerOrEqualParameterTypes(Method method1, Method method2) {
        Class<?>[] params2;
        boolean result;
        Class<?>[] params1 = method1.getParameterTypes();
        boolean bl = result = params1.length == (params2 = method2.getParameterTypes()).length;
        if (result) {
            int size = params1.length;
            int i = 0;
            while (i < size) {
                Class<?> param2 = params2[i];
                Class<?> param1 = params1[i];
                if (!param2.isAssignableFrom(param1)) {
                    result = false;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    private boolean isLowerParameterTypes(Method method1, Method method2) {
        return this.isLowerOrEqualParameterTypes(method1, method2) && !this.isEqualParameterTypes(method1, method2);
    }

    private boolean isEqualParameterTypes(Method method1, Method method2) {
        Class<?>[] params2;
        boolean result;
        Class<?>[] params1 = method1.getParameterTypes();
        boolean bl = result = params1.length == (params2 = method2.getParameterTypes()).length;
        if (result) {
            int size = params1.length;
            int i = 0;
            while (i < size) {
                Class<?> param1 = params1[i];
                Class<?> param2 = params2[i];
                if (param1 != param2) {
                    result = false;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    private boolean isEqual(Method method1, Method method2) {
        return method1.getName().equals(method2.getName()) && this.isEqualParameterTypes(method1, method2);
    }

    private boolean isLower(Method method1, Method method2) {
        return method1.getName().equals(method2.getName()) && this.isLowerParameterTypes(method1, method2);
    }

    @Override
    public IService lookup(String name, Class<?>[] argumentTypes) {
        List<IService> multiMethod = this.getMultimethod(name, argumentTypes.length);
        if (multiMethod == null) {
            return null;
        }
        IService result = null;
        for (IService service : multiMethod) {
            Method method = service.getServiceMethod();
            if (!this.matches(method, argumentTypes) || result != null && !this.isLowerOrEqualParameterTypes(method, result.getServiceMethod())) continue;
            result = service;
        }
        return result;
    }

    @Override
    public boolean isServiceMethod(Object instance, Method method) {
        return method.getDeclaringClass() != Object.class && (instance != null || Modifier.isStatic(method.getModifiers()));
    }

    @Override
    public boolean isCrossReferencerMethod(Method method) {
        boolean crossRefSet = SET_CROSS_REFERENCER_METHOD_NAME.equals(method.getName()) && method.getParameterTypes().length > 0 && CrossReferenceProvider.class.isAssignableFrom(method.getParameterTypes()[0]);
        return crossRefSet;
    }

    private ServiceRegistrationResult registerServices(IServiceProvider provider) throws InvalidAcceleoPackageException {
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        for (IService service : provider.getServices(this.queryEnvironment)) {
            result.merge(this.registerService(provider.getClass(), service));
        }
        return result;
    }

    public ServiceRegistrationResult registerServices(Class<?> newServices) throws InvalidAcceleoPackageException {
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        if (!this.isRegisteredService(newServices)) {
            try {
                Constructor<?> cstr = null;
                Object instance = null;
                try {
                    cstr = newServices.getConstructor(new Class[0]);
                    instance = cstr.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        cstr = newServices.getConstructor(IReadOnlyQueryEnvironment.class);
                        instance = cstr.newInstance(this.queryEnvironment);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {}
                }
                if (instance instanceof IServiceProvider) {
                    result.merge(this.registerServices((IServiceProvider)instance));
                } else {
                    Method[] methods = newServices.getMethods();
                    result.merge(this.getServicesFromInstance(newServices, instance, methods));
                }
            }
            catch (SecurityException e) {
                throw new InvalidAcceleoPackageException(PACKAGE_PROBLEM_MSG + newServices.getCanonicalName(), e);
            }
            catch (InstantiationException e) {
                throw new InvalidAcceleoPackageException(INSTANTIATION_PROBLEM_MSG + newServices.getCanonicalName(), e);
            }
            catch (IllegalAccessException e) {
                throw new InvalidAcceleoPackageException(INSTANTIATION_PROBLEM_MSG + newServices.getCanonicalName(), e);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidAcceleoPackageException(INSTANTIATION_PROBLEM_MSG + newServices.getCanonicalName(), e);
            }
            catch (InvocationTargetException e) {
                throw new InvalidAcceleoPackageException(INSTANTIATION_PROBLEM_MSG + newServices.getCanonicalName(), e);
            }
        }
        return result;
    }

    @Override
    public boolean isRegisteredService(Class<?> cls) {
        return this.classToServices.containsKey(cls);
    }

    public void removeServices(Class<?> servicesClass) {
        Set<IService> servicesSet = this.classToServices.remove(servicesClass);
        if (servicesSet != null) {
            for (IService service : servicesSet) {
                int argc = service.getServiceMethod().getParameterTypes().length;
                Map<String, List<IService>> argcServices = this.services.get(argc);
                String serviceName = service.getServiceMethod().getName();
                List<IService> servicesList = argcServices.get(serviceName);
                servicesList.remove(service);
                if (!servicesList.isEmpty()) continue;
                argcServices.remove(serviceName);
                if (!argcServices.isEmpty()) continue;
                this.services.remove(argc);
            }
        }
    }

    private ServiceRegistrationResult getServicesFromInstance(Class<?> newServices, Object instance, Method[] methods) throws IllegalAccessException, InvocationTargetException {
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (this.isCrossReferencerMethod(method)) {
                method.invoke(instance, this.crossReferencer);
            } else if (this.isServiceMethod(instance, method)) {
                Service service = new Service(method, instance);
                result.merge(this.registerService(newServices, service));
            }
            ++n2;
        }
        return result;
    }

    private ServiceRegistrationResult registerService(Class<?> newServices, IService service) {
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        List<IService> multiMethod = this.getOrCreateMultimethod(service.getServiceMethod().getName(), service.getServiceMethod().getParameterTypes().length);
        for (IService existingService : multiMethod) {
            if (this.isEqual(service.getServiceMethod(), existingService.getServiceMethod())) {
                result.addDuplicated(service.getServiceMethod(), existingService.getServiceMethod());
                continue;
            }
            if (this.isLower(service.getServiceMethod(), existingService.getServiceMethod())) {
                result.addMasked(service.getServiceMethod(), existingService.getServiceMethod());
                continue;
            }
            if (!this.isLower(existingService.getServiceMethod(), service.getServiceMethod())) continue;
            result.addIsMaskedBy(service.getServiceMethod(), existingService.getServiceMethod());
        }
        result.getRegistered().add(service.getServiceMethod());
        multiMethod.add(service);
        Set<IService> servicesSet = this.classToServices.get(newServices);
        if (servicesSet == null) {
            servicesSet = new LinkedHashSet<IService>();
            this.classToServices.put(newServices, servicesSet);
        }
        servicesSet.add(service);
        return result;
    }

    @Override
    public Set<IService> getServices(Set<Class<?>> receiverTypes) {
        LinkedHashSet<IService> result = new LinkedHashSet<IService>();
        for (Class<?> cls : receiverTypes) {
            for (Set<IService> servicesSet : this.classToServices.values()) {
                for (IService service : servicesSet) {
                    if (!service.getServiceMethod().getParameterTypes()[0].isAssignableFrom(cls)) continue;
                    result.add(service);
                }
            }
        }
        return result;
    }
}

