/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.UnbufferedCharStream;
import org.antlr.v4.runtime.UnbufferedTokenStream;
import org.eclipse.acceleo.query.ast.AstPackage;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.ast.ErrorExpression;
import org.eclipse.acceleo.query.parser.AstBuilderListener;
import org.eclipse.acceleo.query.parser.QueryLexer;
import org.eclipse.acceleo.query.parser.QueryParser;
import org.eclipse.acceleo.query.runtime.AcceleoQueryEvaluationException;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class QueryBuilderEngine
implements IQueryBuilderEngine {
    private IQueryEnvironment queryEnvironment;

    public QueryBuilderEngine(IQueryEnvironment queryEnvironment) {
        this.queryEnvironment = queryEnvironment;
    }

    @Override
    public IQueryBuilderEngine.AstResult build(String expression) throws AcceleoQueryEvaluationException {
        IQueryBuilderEngine.AstResult result;
        if (expression != null && expression.length() > 0) {
            UnbufferedCharStream input = new UnbufferedCharStream((Reader)new StringReader(expression), expression.length());
            QueryLexer lexer = new QueryLexer((CharStream)input);
            lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
            UnbufferedTokenStream tokens = new UnbufferedTokenStream((TokenSource)lexer);
            QueryParser parser = new QueryParser((TokenStream)tokens);
            AstBuilderListener astBuilder = new AstBuilderListener(this.queryEnvironment);
            parser.addParseListener(astBuilder);
            parser.addErrorListener(astBuilder.getErrorListener());
            parser.entry();
            result = astBuilder.getAstResult();
        } else {
            ErrorExpression errorExpression = (ErrorExpression)EcoreUtil.create((EClass)AstPackage.eINSTANCE.getErrorExpression());
            ArrayList<Error> errors = new ArrayList<Error>(1);
            errors.add(errorExpression);
            result = new IQueryBuilderEngine.AstResult(errorExpression, errors);
        }
        return result;
    }
}

