/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.internal.ui.actions.AbstractRemoveAllActionDelegate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.launch.LaunchView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IViewPart;

public class LaunchCollapseAllAction
extends AbstractRemoveAllActionDelegate
implements ILaunchesListener2 {
    private IViewPart fView;
    private TreeModelViewer fViewer;

    @Override
    public void init(IViewPart view) {
        Viewer viewer;
        this.fView = view;
        LaunchView debugView = (LaunchView)this.getView().getAdapter(LaunchView.class);
        if (debugView != null) {
            debugView.setAction(this.getActionId(), this.getAction());
        }
        if ((viewer = ((LaunchView)this.getView()).getViewer()) instanceof TreeModelViewer) {
            this.fViewer = (TreeModelViewer)viewer;
        }
        super.init(view);
    }

    private IViewPart getView() {
        return this.fView;
    }

    private String getActionId() {
        return "org.eclipse.ui.navigate.collapseAll";
    }

    public void run(IAction action) {
        if (!(this.getView() instanceof LaunchView)) {
            return;
        }
        if (this.fViewer != null) {
            try {
                this.fViewer.getControl().setRedraw(false);
                this.fViewer.collapseAll();
            }
            finally {
                this.fViewer.getControl().setRedraw(true);
            }
        }
    }

    @Override
    protected void initialize() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    @Override
    public void dispose() {
        super.dispose();
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
    }

    @Override
    protected boolean isEnabled() {
        ILaunch[] launches;
        if (!(this.getView() instanceof LaunchView)) {
            return false;
        }
        return this.fViewer != null && this.fViewer.getInput() != null && (launches = DebugPlugin.getDefault().getLaunchManager().getLaunches()) != null && launches.length > 0;
    }

    public void launchesRemoved(ILaunch[] launches) {
        this.update();
    }

    public void launchesAdded(ILaunch[] launches) {
        this.update();
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesTerminated(ILaunch[] launches) {
    }
}

