package Net::Amazon::EMR::ClusterSummary;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;
use Net::Amazon::EMR::ClusterStatus;

has 'Id' => ( is => 'ro', 
              isa => 'Str' );

has 'Name' => ( is => 'ro', 
                isa => 'Str' );

has 'NormalisedInstanceHours' => ( is => 'ro', 
                                   isa => 'Int' );

has 'Status' => ( is => 'ro',
                  isa => 'Net::Amazon::EMR::Type::ClusterStatus',
                  coerce => 1,
);


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::ClusterSummary

=head1 DESCRIPTION

Implements the ClusterSummary data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_ClusterSummary.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
