use NetAddr::IP::Lite;

my @yes_pairs = (
		 [ [ '127.0.0.0', '255.0.0.0' ],
		   [ '127.0.0.1', '255.255.255.255'] ],
		 [ [ '10.0.0.0', '255.255.255.0' ],
		   [ '10.0.0.128', '255.255.255.128' ] ],
		 [ [ '10.0.0.0', '255.0.0.0' ],
		   [ '10.0.0.0', '255.0.0.0' ]],
		 [ [ '10.0.0.0', '255.0.0.0' ],
		   [ '10.0.0.1', '255.0.0.0' ]],
		 [ [ '10.0.0.0', '255.255.255.254' ],
		   [ '10.0.0.1', '255.255.255.254' ]],
		 [ [ '10.0.0.0', '255.255.255.254' ],
		   [ '10.0.0.1', '255.255.255.255' ]],
		 [ [ '10.0.0.1', '255.0.0.0' ],
		   [ '10.0.0.1', '255.255.255.255' ]],
		 [ [ 'default', 'default' ],
		   [ '10.0.0.1', '255.255.255.254' ]],
		 [ [ 'default', 'default' ],
		   [ 'broadcast', undef ]],
		 [ [ 'loopback', '255.0.0.0' ],
		   [ '127.0.0.0', '255.0.0.0' ] ],
		 );

my @no_pairs = (
		[ [ '127.0.0.1', '255.255.255.255' ],
		  [ '127.0.0.0', '255.0.0.0' ] ],
		[ [ '10.0.0.0', '255.0.0.0' ],
		  [ '11.0.0.0', '255.0.0.0' ] ],
		[ [ '10.0.1.0', '255.255.255.0' ],
		  [ '10.0.2.0', '255.255.255.0' ] ],
		 [ [ '10.0.0.1', '255.255.255.254' ],
		   [ 'default', '0' ] ],
		);

$| = 1;
print "1..", 2 * (scalar @yes_pairs + scalar @no_pairs), "\n";

my $count = 1;

for my $p (@yes_pairs) {
    my $ip_a = new NetAddr::IP::Lite $p->[0]->[0], $p->[0]->[1];
    my $ip_b = new NetAddr::IP::Lite $p->[1]->[0], $p->[1]->[1];
    print (($ip_a->contains($ip_b) ? '' : 'not '), 'ok ', $count++, "\n");
    print (($ip_b->within($ip_a) ? '' : 'not '), 'ok ', $count++, "\n");

#    print "a = ", $ip_a->addr, "/", $ip_a->mask, "\n";
#    print "b = ", $ip_b->addr, "/", $ip_b->mask, "\n";

}

for my $p (@no_pairs) {
    my $ip_a = new NetAddr::IP::Lite $p->[0]->[0], $p->[0]->[1];
    my $ip_b = new NetAddr::IP::Lite $p->[1]->[0], $p->[1]->[1];
    print (($ip_a->contains($ip_b) ? 'not ' : ''), 'ok ', $count++, "\n");
    print (($ip_b->within($ip_a) ? 'not ' : ''), 'ok ', $count++, "\n");
}


