#!/usr/bin/perl

package eBay::API::XML::DataType::CheckoutOrderDetailType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. CheckoutOrderDetailType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::CheckoutOrderDetailType

=head1 DESCRIPTION

Details of the order for a checked out cart.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::CheckoutOrderDetailType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AmountType;


my @gaProperties = ( [ 'TotalAmount', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'TotalCartMerchandiseCost', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'TotalCartShippingCost', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'TotalTaxAmount', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setTotalAmount()

The overall total cost (including item cost, shipping cost and taxes).

#    Argument: 'ns:AmountType'

=cut

sub setTotalAmount {
  my $self = shift;
  $self->{'TotalAmount'} = shift
}

=head2 getTotalAmount()

#    Returns: 'ns:AmountType'

=cut

sub getTotalAmount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'TotalAmount'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setTotalCartMerchandiseCost()

The total item cost of all items in the cart.

#    Argument: 'ns:AmountType'

=cut

sub setTotalCartMerchandiseCost {
  my $self = shift;
  $self->{'TotalCartMerchandiseCost'} = shift
}

=head2 getTotalCartMerchandiseCost()

#    Returns: 'ns:AmountType'

=cut

sub getTotalCartMerchandiseCost {
  my $self = shift;
  return $self->_getDataTypeInstance( 'TotalCartMerchandiseCost'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setTotalCartShippingCost()

The total shipping cost of all items in the cart.

#    Argument: 'ns:AmountType'

=cut

sub setTotalCartShippingCost {
  my $self = shift;
  $self->{'TotalCartShippingCost'} = shift
}

=head2 getTotalCartShippingCost()

#    Returns: 'ns:AmountType'

=cut

sub getTotalCartShippingCost {
  my $self = shift;
  return $self->_getDataTypeInstance( 'TotalCartShippingCost'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setTotalTaxAmount()

The total tax for all items in the cart.

#    Argument: 'ns:AmountType'

=cut

sub setTotalTaxAmount {
  my $self = shift;
  $self->{'TotalTaxAmount'} = shift
}

=head2 getTotalTaxAmount()

#    Returns: 'ns:AmountType'

=cut

sub getTotalTaxAmount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'TotalTaxAmount'
		,'eBay::API::XML::DataType::AmountType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
