/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.ocrPlugins;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.sourceforge.javaocr.scanner.DocumentScanner;
import net.sourceforge.javaocr.scanner.DocumentScannerListenerAdaptor;
import net.sourceforge.javaocr.scanner.PixelImage;

public class LineExtractor
extends DocumentScannerListenerAdaptor {
    private int num = 0;
    private DocumentScanner documentScanner = new DocumentScanner();
    private File outputDir = null;
    private File inputImage = null;
    private static final Logger LOG = Logger.getLogger(LineExtractor.class.getName());

    public void slice(File inputImage, File outputDir) {
        try {
            this.inputImage = inputImage;
            this.outputDir = outputDir;
            BufferedImage img = ImageIO.read(inputImage);
            PixelImage pixelImage = new PixelImage(img);
            pixelImage.toGrayScale(true);
            pixelImage.filter();
            this.documentScanner.scan(pixelImage, this, 0, 0, pixelImage.width, pixelImage.height);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public void beginRow(PixelImage pixelImage, int y1, int y2) {
        try {
            int areaH = y2 - y1;
            BufferedImage img = ImageIO.read(this.inputImage);
            int areaW = img.getWidth();
            img = img.getSubimage(0, y1, areaW, areaH);
            File outputfile = new File(this.outputDir + File.separator + "line_" + this.num + ".png");
            ImageIO.write((RenderedImage)img, "png", outputfile);
            ++this.num;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }
}

