package Map::Tube::Rome::Line::MA;

$Map::Tube::Rome::Line::MA::VERSION   = '1.03';
$Map::Tube::Rome::Line::MA::AUTHORITY = 'cpan:GDT';

use 5.010;
use strict;
use warnings;

=head1 NAME

Map::Tube::Rome::Line::MA - Rome Subway Map: Linea A.

=head1 DESCRIPTION

Rome Subway Map: Linea A

    .-----------------------------------------------------------------------------------------------------------------------.
    | Station Name                             | Connected To                                                               |
    +------------------------------------------+----------------------------------------------------------------------------+
    | Anagnina                                 | Cinecittà                                                                  |
    | Cinecittà                                | Anagnina, Subaugusta                                                       |
    | Subaugusta                               | Cinecittà, Giulio Agricola - Parco degli Acquedotti                        |
    | Giulio Agricola - Parco degli Acquedotti | Subaugusta, Lucio Sestio                                                   |
    | Lucio Sestio                             | Giulio Agricola - Parco degli Acquedotti, Numidio Quadrato                 |
    | Numidio Quadrato                         | Lucio Sestio, Porta Furba Quadraro                                         |
    | Porta Furba Quadraro                     | Numidio Quadrato, Arco di Travertino                                       |
    | Arco di Travertino                       | Porta Furba Quadraro, Colli Albani - Parco Appia Antica                    |
    | Colli Albani - Parco Appia Antica        | Arco di Travertino, Furio Camillo                                          |
    | Furio Camillo                            | Colli Albani - Parco Appia Antica, Ponte Lungo                             |
    | Ponte Lungo                              | Furio Camillo, Re di Roma                                                  |
    | Re di Roma                               | Ponte Lungo, San Giovanni                                                  |
    | San Giovanni                             | Re di Roma, Manzoni, Lodi, Porta Metronia                                  |
    | Manzoni                                  | San Giovanni, Vittorio Emanuele                                            |
    | Vittorio Emanuele                        | Manzoni, Termini                                                           |
    | Termini                                  | Vittorio Emanuele, Repubblica - Teatro dell'Opera, Castro Pretorio, Cavour |
    | Repubblica - Teatro dell'Opera           | Termini, Barberini - Fontana di Trevi                                      |
    | Barberini - Fontana di Trevi             | Repubblica - Teatro dell'Opera, Spagna                                     |
    | Spagna                                   | Barberini - Fontana di Trevi, Flaminio - Piazza del Popolo                 |
    | Flaminio - Piazza del Popolo             | Spagna, Lepanto                                                            |
    | Lepanto                                  | Flaminio - Piazza del Popolo, Ottaviano - San Pietro - Musei Vaticani      |
    | Ottaviano - San Pietro - Musei Vaticani  | Lepanto, Cipro                                                             |
    | Cipro                                    | Ottaviano - San Pietro - Musei Vaticani, Valle Aurelia                     |
    | Valle Aurelia                            | Cipro, Baldo degli Ubaldi                                                  |
    | Baldo degli Ubaldi                       | Valle Aurelia, Cornelia                                                    |
    | Cornelia                                 | Baldo degli Ubaldi, Battistini                                             |
    | Battistini                               | Cornelia                                                                   |
    '------------------------------------------+----------------------------------------------------------------------------'

=head1 NOTE

=over 2

=item * The station "Termini" is also part of
          L<Linea B|Map::Tube::Rome::Line::MB>.

=item * The station "San Giovanni" is also part of
          L<Linea C|Map::Tube::Rome::Line::MC>.

=back

=head1 MAP

Rome Subway Map: L<Linea A|https://raw.githubusercontent.com/giterlizzi/perl-Map-Tube-Rome/main/maps/MA.png>
map generated by plugin L<Map::Tube::Plugin::Graph>.

=begin html

<a href = "https://raw.githubusercontent.com/giterlizzi/perl-Map-Tube-Rome/main/maps/MA.png">
<img src = "https://raw.githubusercontent.com/giterlizzi/perl-Map-Tube-Rome/main/maps/MA.png"
     alt = "Rome Subway Map: Linea A" />
</a>

=end html

=head1 SUPPORT

=head2 Bugs / Feature Requests

Please report any bugs or feature requests through the issue tracker
at L<https://github.com/giterlizzi/perl-Map-Tube-Rome/issues>.
You will be notified automatically of any progress on your issue.

=head2 Source Code

This is open source software.  The code repository is available for
public review and contribution under the terms of the license.

L<https://github.com/giterlizzi/perl-Map-Tube-Rome>

    git clone https://github.com/giterlizzi/perl-Map-Tube-Rome.git

=head1 AUTHOR

Giuseppe Di Terlizzi <gdt@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024-2025 by Giuseppe Di Terlizzi <gdt@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

1;    # End of Map::Tube::Rome::Line::MA
