# ----------------------------------------------------------------
    use strict;
    use Test::More tests => 6;
    BEGIN { use_ok('XML::FeedPP') };
# ----------------------------------------------------------------
    my $rss = XML::FeedPP::RSS->new();
    like( $rss->to_string(), qr/<rss/, "rss" );
# ----------------------------------------------------------------
    my $rdf = XML::FeedPP::RDF->new();
    like( $rdf->to_string(), qr/<rdf:RDF/, "rdf" );
# ----------------------------------------------------------------
    my $atom = XML::FeedPP::Atom->new();
    like( $atom->to_string(), qr/<feed/, "atom" );
# ----------------------------------------------------------------
    my $atom03 = XML::FeedPP::Atom::Atom03->new();
    like( $atom03->to_string(), qr/<feed[^>]*version="0.3"/, "atom 0.3" );
# ----------------------------------------------------------------
    my $atom10 = XML::FeedPP::Atom::Atom10->new();
    like( $atom10->to_string(), qr{<feed[^>]*http://www.w3.org/2005/Atom}, "atom 1.0" );
# ----------------------------------------------------------------
;1;
# ----------------------------------------------------------------
