# Copyrights 2001-2025 by [Mark Overmeer <markov@cpan.org>].
#  For other contributors see ChangeLog.
# See the manual pages for details on the licensing terms.
# Pod stripped from pm file by OODoc 2.02.
# This code is part of distribution Mail-Message.  Meta-POD processed with
# OODoc into POD and HTML manual-pages.  See README.md
# Copyright Mark Overmeer.  Licensed under the same terms as Perl itself.

package Mail::Message::TransferEnc::Binary;
use vars '$VERSION';
$VERSION = '3.018_001';

use base 'Mail::Message::TransferEnc';

use strict;
use warnings;


sub name() { 'binary' }

sub check($@)
{   my ($self, $body, %args) = @_;
    $body;
}

sub decode($@)
{   my ($self, $body, %args) = @_;
    $body->transferEncoding('none');
    $body;
}

sub encode($@)
{   my ($self, $body, %args) = @_;
    my @lines;

    my $changes = 0;
    foreach ($body->lines)
    {   $changes++ if s/[\000\013]//g;
        push @lines, $_;
    }

    unless($changes)
    {   $body->transferEncoding('none');
        return $body;
    }

    my $bodytype = $args{result_type} || ref($self->load);

    $bodytype->new
      ( based_on          => $self
      , transfer_encoding => 'none'
      , data              => \@lines
      );
}

1;
