package Acme::MetaSyntactic::asterix;
use strict;
use Acme::MetaSyntactic::Locale;
our @ISA = qw( Acme::MetaSyntactic::Locale );
our $VERSION = '1.000';
__PACKAGE__->init();
1;

=head1 NAME

Acme::MetaSyntactic::asterix - Asterix the Gaul

=head1 DESCRIPTION

Characters from the famous French cartoon, created by Goscinny and Uderzo.

=head2 Languages

Supported languages:
I<en>, I<en_us>, I<fr>, I<nl>, I<de>, I<es>, I<gl>, I<hu>, I<la>, I<pt>, I<sv>.

Reference sites:
L<http://en.wikipedia.org/wiki/Asterix>,
L<http://asterix.openscroll.org/characters.html>.

=head1 CONTRIBUTOR

Abigail

=head1 CHANGES

=over 4

=item *

2012-10-01 - v1.000

Published in Acme-MetaSyntactic-Themes version 1.021.

=item *

2005-10-25

Submitted by Abigail, with the names translated in 11 languages.

=back

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<Acme::MetaSyntactic::Locale>.

=cut

#
# It seems that in the US different names are used than in the UK. For
# the names I don't have a US name, I copied the US name.
#
# The lists aren't complete.
#

__DATA__
# default
fr
# names en
Asterix
Obelix
Dogmatix
Getafix
Vitalstatistix
Impedimenta
Cacofonix
Fulliautomatix
Unhygienix
Bacteria
Geriatrix

Julius_Caesar
Cleopatra
Brutus
Postaldistrix
Picanmix
Redbeard
Pegleg
Boy
Panacea
Ekonomikrisis
Tragicomix
Tremendelirius
Drinklikafix
# names en_us
Asterix
Obelix
Dogmatix
Magigimmix
Arthritix Macroeconomix
Belladonna
Malacoustix
Fulliautomatix
Epidemix
Bacteria
Geriatrix

Julius_Caesar
Cleopatra
Brutus
Postaldistrix
Picanmix
Redbeard
Pegleg
Boy
Panacea
Ekonomikrisis
Tragicomix
Tremendelirius
Drinklikafix
# names fr
Asterix
Obelix
Idefix
Panoramix
Abraracourcix
Bonemine
Assurancetourix
Cetautomatix
Ordralfabetix
Ielosubmarine
Agecanonix

Jules_Cesar
Cleopatre
Brutus
Pneumatix
Keskonrix
Barbe_Rouge

Baba
Falbala
Epidemais


Zaza
Aplusbegalix
Amerix
Caius_Bonus
# names nl
Asterix
Obelix
Idefix
Panoramix
Abraracourcix Heroix

Assurancetourix Kakofonix
# names de
Alkoholix
Asterix
Astronomix
Automatix
Claudius_Bockschus
Costa_Y_Bravo
Brutus
Julius_Casar
Tullius_Destruktivus
Eleonoradus
Falbala
Gelatine
Grautvornix
Gutemine
Homoopatix
Acidix_Hydrochloridix
Idefix
Jellosubmarine
Kantine
Lucius_Keuchhustus
Kleopatra
Majestix
Olaf_Maulaf
Methusalix
Miraculix
Moralelastix
Nixalsverdrus Hotelterminus
Numerobis
Obelix
Orthopadix
Osolemirnix
Ozeanix
Praline
Processus
Feistus_Raclettus
Gaius_Raffcus
Rohrpostix
Salamix
Studicus
Taubenus
Technokratus
Teefax
Tragicomix
Troubadix
Vaseline
Verleihnix
Agrippus_Virus
Vreneli
Volligbaf
Zechine
# names es
Asterix
Obelix
Panoramix
Asuranceturix
Abraracurcix
Karabella
Ordenalfabetix
Esautomatix
Edadepiedrix
Idefix Ideafix
Julio_Cesar
Cleopatra
# names gl
Asterix
Obelix
Panoramix
Abraracurcix Abrazopartidix
Karabella
Asuracenturix Seguroatodoriesguix
Ideafix Idefix
# names hu
Asterix
Obelix
Mirnixdirnix
Magicoturmix
Hasarengazfix
Hangianix
Messesaglix
Sokadikix
# names la
Asterix
Obelix
Idefix
Miraculix
Maiestix
Troubadix
# names pt
Asterix
Obelix
Chatotorix
Abracurcix
Ideiafix
Panoramix
# names sv
Asterix
Obelix
Idefix
Miraculix
Troubadix
Majestix
Senilix
Smidefix
Crabbofix
Bonemine
Fru_Crabbofix
Julius_Caesar
