# Generated by default/object.tt
package Paws::SecurityHub::CustomDataIdentifiersDetections;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str');
  has Count => (is => 'ro', isa => 'Int');
  has Name => (is => 'ro', isa => 'Str');
  has Occurrences => (is => 'ro', isa => 'Paws::SecurityHub::Occurrences');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::CustomDataIdentifiersDetections

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::CustomDataIdentifiersDetections object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Occurrences => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::CustomDataIdentifiersDetections object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

The list of detected instances of sensitive data.

=head1 ATTRIBUTES


=head2 Arn => Str

The ARN of the custom identifier that was used to detect the sensitive
data.


=head2 Count => Int

The total number of occurrences of sensitive data that were detected.


=head2 Name => Str

he name of the custom identifier that detected the sensitive data.


=head2 Occurrences => L<Paws::SecurityHub::Occurrences>

Details about the sensitive data that was detected.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

