/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import java.security.AccessControlException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.couchbase.mock.Bucket;
import org.couchbase.mock.memcached.Item;
import org.couchbase.mock.memcached.MemcachedServer;

public class VBucket {
    private MemcachedServer owner;
    private Map<String, Item> map;

    public VBucket(MemcachedServer owner) {
        this.owner = owner;
        this.map = new ConcurrentHashMap<String, Item>();
    }

    public synchronized void setOwner(MemcachedServer server) {
        this.owner = server;
    }

    public synchronized Map<String, Item> getMap(MemcachedServer server) {
        if (server.getType() == Bucket.BucketType.COUCHBASE && server != this.owner) {
            throw new AccessControlException("Not my VBucket");
        }
        return this.map;
    }

    public synchronized MemcachedServer getOwner() {
        return this.owner;
    }

    void flush(MemcachedServer server) {
        if (this.owner == server) {
            this.map.clear();
        }
    }
}

