#!/usr/bin/env perl

use strict;
use warnings;

use Test::More;
use Test::Deep;

use Promise::ES6;

my @warnings;
local $SIG{'__WARN__'} = sub { push @warnings, @_ };

#----------------------------------------------------------------------

my @tests = (
    sub {
        Promise::ES6->new( sub { die 123 } );

        cmp_deeply(
            \@warnings,
            [ re( qr<123> ) ],
            'warn() as expected when constructor callback die()s',
        );
    },
    sub {
        my ($res, $rej);
        my $p = Promise::ES6->new( sub { ($res, $rej) = @_ } )->catch( sub { 123 } );

        $rej->(123);

        cmp_deeply(
            \@warnings,
            [],
            'don’t warn() if there is a rejection handler',
        );
    },
    sub {
        Promise::ES6->new( sub { my ($res, $rej) = @_; $rej->(123) } );

        cmp_deeply(
            \@warnings,
            [ re( qr<123> ) ],
            'warn() as expected when constructor callback rejects',
        );
    },
    sub {
        Promise::ES6->new(
            sub { my ($res, $rej) = @_; $rej->(123) },
        )->then( sub { 234 } );

        cmp_deeply(
            \@warnings,
            [ re( qr<123> ) ],
            'warn() only once',
        );
    },

    sub {
        my $p = Promise::ES6->new(
            sub { my ($res, $rej) = @_; $rej->(123) },
        );

        $p->catch( sub { 234 } )->then( sub { die 345 } );

        cmp_deeply(
            \@warnings,
            [ re( qr<123> ), re( qr<345> ) ],
            'warn() again when a promise is caught after initial failure but then rejects later (uncaught)',
        );
    },
);

for my $t (@tests) {
    $t->();
    @warnings = ();
}

done_testing();
